package Cookbook::WinBitHack;

BEGIN {
  eval{ 
    require Win32::File;
    Win32::File->import(qw(READONLY ARCHIVE));
  };
}

use Apache::Constants qw(OK DECLINED OPT_INCLUDES DECLINE_CMD);
use Apache::File;
use Apache::ModuleConfig;

use DynaLoader;

use 5.006;

use strict;

our $VERSION = '0.01';
our @ISA = qw(DynaLoader);

__PACKAGE__->bootstrap($VERSION);

sub handler {
  # Implementacja dyrektywy XBitHack w systemach Win32.
  # Uycie: PerlModule Cookbook::WinBitHack
  #         PerlFixupHandler Cookbook::WinBitHack
  #         XBitHack On|Off|Full

  my $r = shift;

  my $cfg = Apache::ModuleConfig->get($r, __PACKAGE__);

  return DECLINED unless (
     $^O =~ m/Win32/                  &&    # system Win32
     -f $r->finfo                     &&    # i plik istnieje
     $r->content_type eq 'text/html'  &&    # i jest dokumentem HTML
     $r->allow_options & OPT_INCLUDES &&    # i wczono opcj +Includes
     $cfg->{_state} ne 'OFF');              # i XBitHack ma warto On lub Full

  # Pobieramy atrybuty pliku.
  my $attr;
  Win32::File::GetAttributes($r->filename, $attr);

  # Zwracamy warto DECLINED, jeeli plik ma ustawiony atrybut ARCHIVE,
  # czyli w wikszoci przypadkw.
  return DECLINED if $attr & ARCHIVE();

  # Ustawiamy nagwek Last-Modified, jeeli atrybut READONLY nie jest ustawiony.
  if ($cfg->{_state} eq 'FULL') {
    $r->set_last_modified((stat _)[9]) unless $attr & READONLY();
  }

  # Upewniamy si, e modu mod_include zajmie si daniem.
  $r->handler('server-parsed');

  return OK;
}

sub DIR_CREATE {

  my $class = shift;
  my %self  = ();

  # Dyrektywa XBitHack jest domylnie wyczona.
  $self{_state} = "OFF";

  return bless \%self, $class;
}

sub DIR_MERGE {

  my ($parent, $current) = @_;
  my %new = (%$parent, %$current);

  return bless \%new, ref($parent);
}

sub XBitHack ($$$) {

  my ($cfg, $parms, $arg) = @_;

  # Modu mod_include dziaa w systemach uniksowych - my zajmujemy si tylko Win32.
  return DECLINE_CMD unless $^O =~ m/Win32/;

  if ($arg =~ m/^(On|Off|Full)$/i) {
    $cfg->{_state} = uc($arg);
  }
  else {
    die "Nieprawidowa warto XbitHack: $arg!";
  }
}
1;
