package Cookbook::Clean;

use Apache::Constants qw( OK DECLINED );
use Apache::File;
use Apache::Log;
use Apache::ModuleConfig;

use DynaLoader ();
use HTML::Clean;

use 5.006;

our $VERSION = '0.02';
our @ISA = qw(DynaLoader);

__PACKAGE__->bootstrap($VERSION);

use strict;

sub handler {

  my $r = shift;

  my $log = $r->server->log;

  my $cfg = Apache::ModuleConfig->get($r, __PACKAGE__);

  unless ($r->content_type eq 'text/html') {
    $log->info("danie nie dotyczy dokumentu HTML - pomijamy...");
    return DECLINED; 
  }

  my $fh = Apache::File->new($r->filename);

  unless ($fh) {
    $log->warn("Nie mona otworzy danego pliku - pomijamy... $!");
    return DECLINED;
  }

  # Wczytujemy cay plik (miejmy nadziej, e nie jest zbyt duy).
  my $dirty = do {local $/; <$fh>};

  # Tworzymy nowy obiekt HTML::Clean.
  my $h = HTML::Clean->new(\$dirty);

  # Ustawiamy poziom "czystoci".
  $h->level($cfg->{_level});

  # Nie ma potrzeby sprawdzania, czy klucz _options istnieje, gdy
  # teraz inicjalizujemy dane w podprogramie DIR_CREATE().
  $h->strip($cfg->{_options});

  # Wysyamy oczyszczony kod HTML.
  $r->send_http_header('text/html');
  print ${$h->data};

  return OK;
}

sub CleanLevel ($$$) {

  my ($cfg, $parms, $arg) = @_;

  die "Nieprawidowa warto CleanLevel: $arg!" unless $arg =~ m/^[1-9]$/;

  $cfg->{_level}  = $arg;
}

sub CleanOption ($$@) {

  my ($cfg, $parms, $arg) = @_;

  my %possible = map {$_ => 1} qw(whitespace shortertags blink contenttype
                                  comments entities dequote defcolor
                                  javascript htmldefaults lowercasetags);

  if ($possible{lc $arg}) {
    $cfg->{_options}{lc $arg} = 1;
  }
  else {
    die "Nieprawidowa warto CleanOption: $arg!";
  }
}

sub DIR_CREATE {
  # Inicjalizujemy obiekt, zamiast uy domylnego dla moduu mod_perl.

  my $class = shift;
  my %self  = ();

  $self{_level}   = 1;   # domylnie 1
  $self{_options} = {};  # aby nie trzeba byo sprawdza, czy istnieje

  return bless \%self, $class;
}

sub DIR_MERGE {
  # Zezwalamy podkatalogowi odziedziczy ustawienia po katalogu nadrzdnym,
  # nadpisujc ustawieniami wyspecyfikowanymi w podkatalogu.

  my ($parent, $current) = @_;

  my %new = (%$parent, %$current);

  return bless \%new, ref($parent);
}
1;
