package Cookbook::Clean;

use Apache::Constants qw( OK DECLINED );
use Apache::File;
use Apache::Log;
use Apache::ModuleConfig;

use DynaLoader ();
use HTML::Clean;

use 5.006;

our $VERSION = '0.01';
our @ISA = qw(DynaLoader);

__PACKAGE__->bootstrap($VERSION);

use strict;

sub handler {

  my $r = shift;

  my $log = $r->server->log;

  my $cfg = Apache::ModuleConfig->get($r, __PACKAGE__);

  unless ($r->content_type eq 'text/html') {
    $log->info("danie nie dotyczy dokumentu HTML - pomijamy...");
    return DECLINED; 
  }

  my $fh = Apache::File->new($r->filename);

  unless ($fh) {
    $log->warn("Nie mona otworzy danego pliku - pomijamy... $!");
    return DECLINED;
  }

  # Wczytujemy cay plik (miejmy nadziej, e nie jest zbyt duy).
  my $dirty = do {local $/; <$fh>};

  # Tworzymy nowy obiekt HTML::Clean.
  my $h = HTML::Clean->new(\$dirty);

  # Ustawiamy poziom "czystoci".
  $h->level($cfg->{_level} || 1);

  # Upewniamy si, e mapa istnieje i przepisujemy j do zmienej %options.
  my %options = $cfg->{_options} ? %{$cfg->{_options}} : ();

  # Czycimy kod HTML.
  $h->strip(\%options);

  # Wysyamy oczyszczone dane.
  $r->send_http_header('text/html');
  print ${$h->data};

  return OK;
}

sub CleanLevel ($$$) {

  my ($cfg, $parms, $arg) = @_;

  die "Nieprawidowa warto CleanLevel: $arg!" unless $arg =~ m/^[1-9]$/;

  $cfg->{_level}  = $arg;
}

sub CleanOption ($$@) {

  my ($cfg, $parms, $arg) = @_;


  my %possible = map {$_ => 1} qw(whitespace shortertags blink contenttype
                                  comments entities dequote defcolor
                                  javascript htmldefaults lowercasetags);

  if ($possible{lc $arg}) {
    $cfg->{_options}{lc $arg} = 1;
  }
  else {
    die "Nieprawidowa warto CleanOption: $arg!";
  }
}
1;
