package Cookbook::Clean;

use Apache::Constants qw( OK DECLINED );
use Apache::File;
use Apache::Log;
use Apache::ModuleConfig;

use DynaLoader ();
use HTML::Clean;

use 5.006;

our $VERSION = '0.02';
our @ISA = qw(DynaLoader);

__PACKAGE__->bootstrap($VERSION);

use strict;

# Pobieramy czas modyfikacji moduu...
(my $package = __PACKAGE__) =~ s!::!/!g;
my $package_mtime = (stat $INC{"$package.pm"})[9];

# ...oraz pliku httpd.conf.
my $conf_mtime = (stat Apache->server_root_relative('conf/httpd.conf'))[9];

# Inicjalizujemy bufor podrczny.
my %filedata = ();
die "Nie mona zainicjalizowa bufora podrcznego!"
  unless Cache::SharedMemoryCache->new->set(file => \%filedata);

# Kiedy serwer jest restartowany, musimy...
Apache->server->register_cleanup(sub { 
  # ...wyczyci bufor podrczny...
  Cache::SharedMemoryCache->Clear;

  # ...i upewni si, e wykrywamy zmiany w pliku konfiguracyjnym, aby przesa 
  # do klienta informacj o koniecznoci oprnienia jego buforw podrcznych.
  $conf_mtime = (stat Apache->server_root_relative('conf/httpd.conf'))[9]; 
});

sub handler {

  my $r = shift;

  my $filename = $r->filename;

  my $cfg = Apache::ModuleConfig->get($r, __PACKAGE__);

  return DECLINED unless ($r->content_type eq 'text/html');

  my $fh = Apache::File->new($filename);

  return DECLINED unless $fh;

  # Sprawdzamy, czy wygenerowa nowe dane, czy uy tych, ktre mamy.
  my $cache = Cache::SharedMemoryCache->new;

  my $filedata = $cache->get('file');

  my $file_mtime = (stat $r->finfo)[9];
  my $cache_mtime = $filedata->{$filename}->{_mtime};

  # Generujemy nowy bufor podrczny, jeeli...
  unless ($cache_mtime &&                   # nie mamy bufora
          $cache_mtime == $file_mtime) {    # albo plik zosta zmieniony.

    my $dirty = do {local $/; <$fh>};

    my $h = HTML::Clean->new(\$dirty);

    $h->level($cfg->{_level});

    $h->strip($cfg->{_options});

    # Inicjalizujemy bufor podrczny danymi z pliku.
    $filedata->{$filename}{_clean} = ${$h->data};

    $filedata->{$filename}{_mtime} = $file_mtime;

    $cache->set(file => $filedata);
  }

  # W tym miejscu mamy ju czysty kod HTML, albo z bufora, albo wieo wygenerowany.
  my $clean = $filedata->{$filename}->{_clean};

  # Wysyamy dane z odpowiednimi nagwkami, aby uy
  # zarwno bufora podrcznego klienta, jak i serwera.
  $r->update_mtime($package_mtime);
  $r->update_mtime($file_mtime);
  $r->update_mtime($conf_mtime);
  $r->set_last_modified;
  $r->set_content_length(length $clean);

  if ((my $status = $r->meets_conditions) == OK) {
    $r->send_http_header('text/html');
    print $clean;
    return OK;
  }
  else {
    return $status;
  }
}

sub CleanLevel ($$$) {

  my ($cfg, $parms, $arg) = @_;

  die "Nieprawidowa warto CleanLevel: $arg!" unless $arg =~ m/^[1-9]$/;

  $cfg->{_level}  = $arg;
}

sub CleanOption ($$@) {

  my ($cfg, $parms, $arg) = @_;

  my %possible = map {$_ => 1} qw(whitespace shortertags blink contenttype
                                  comments entities dequote defcolor
                                  javascript htmldefaults lowercasetags);

  if ($possible{lc $arg}) {
    $cfg->{_options}{lc $arg} = 1;
  }
  else {
    die "Nieprawidowa warto CleanOption: $arg!";
  }
}

sub DIR_CREATE {
  # Inicjalizujemy obiekt, zamiast uy domylnego dla moduu mod_perl.

  my $class = shift;
  my %self  = ();

  $self{_level}   = 1;   # domylnie 1
  $self{_options} = {};  # aby nie trzeba byo sprawdza, czy istnieje

  return bless \%self, $class;
}

sub DIR_MERGE {
  # Zezwalamy podkatalogowi odziedziczy ustawienia po katalogu nadrzdnym,
  # nadpisujc ustawieniami wyspecyfikowanymi w podkatalogu.

  my ($parent, $current) = @_;

  my %new = (%$parent, %$current);

  return bless \%new, ref($parent);
}
1;

