package Cookbook::MIMEMapper;

use Apache::Constants qw(OK DECLINED DECLINE_CMD);
use Apache::ModuleConfig ();

use 5.006;
use DynaLoader ();
use MIME::Types qw(by_suffix);

use strict;

our $VERSION = '0.01';
our @ISA = qw(DynaLoader);

__PACKAGE__->bootstrap($VERSION);

sub handler {

  my $r = shift;

  # Odmawiamy, jeeli jest to danie do serwera proxy.
  return DECLINED if $r->proxyreq;

  my $cfg = Apache::ModuleConfig->get($r, __PACKAGE__);

  # Odmawiamy rwnie, jeeli wystpia dyrektywa SetHandler,
  # gdy nadpisuje ona ustawienia dyrektywy AddHandler.
  return DECLINED if $cfg->{_set_handler};

  my ($extension) = $r->filename =~ m!(\.[^.]+)$!;

  # Ustawiamy acuch programw obsugi typu PerlHandler,
  # jeeli skonfigurowano mapowanie dla tego rozszerzenia.
  if (my $handlers = $cfg->{$extension}) {
    $r->handler('perl-script');
    $r->set_handlers(PerlHandler => $handlers);

    # Jeeli jest wiele programw obsugi PerlHandler,
    # musimy powiadomi modu Apache::Filter...
    $r->dir_config->set(Filter => 'On') if @$handlers > 1;

    # ...i "odgadn" typ MIME.
    my ($content_type) = by_suffix($extension);
    $r->content_type($content_type) if $content_type;

    return OK;
  }

  # W przeciwnym wypadku, niech obsug zajmie si modu mod_mime.
  return DECLINED;
}

sub AddHandler ($$@;@) {
  my ($cfg, $parms, $handler, $type) = @_;

  # Przechwytujemy dyrektyw, jeeli program obsugi "wyglda" jak PerlHandler.
  # Nie jest to idealne sprawdzenie, ale na razie wystarczy.
  if ($handler =~ m/::/) {
    push @{$cfg->{$type}}, $handler;
    return OK;
  }

  # W przeciwnym wypadku, niech obsug zajmie si modu mod_mime.
  return DECLINE_CMD;
}

sub SetHandler ($$$) {
  my ($cfg, $parms, $handler) = @_;

  $cfg->{_set_handler} = 1;

  # Zapamitujemy tylko obszary zarzdzane przez dyrektyw SetHandler.
  return DECLINE_CMD;
}

sub DIR_CREATE {
  return bless {}, shift;
}

sub DIR_MERGE {
  my ($parent, $current) = @_;

  my %new = (%$parent, %$current);

  return bless \%new, ref($parent);
}
1;
