#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "mod_perl.h"

static FILE *original_log;

MODULE = Cookbook::DivertErrorLog      PACKAGE = Cookbook::DivertErrorLog

PROTOTYPES: ENABLE

int
set(s, fd)
  Apache::Server s
  int fd

  PREINIT:
    pool *p;

  CODE:
    RETVAL = 1;

    /* Pobieramy pul pamici. */
    p = perl_get_startup_pool();

    /* Zapamitujemy oryginalny uchwyt pliku dziennika bdw. */
    original_log = s->error_log;

    /*
     * Otwieramy deskryptor nowego dziennika bdw w trybie do zapisu.
     * W przypadku bdu odtwarzamy oryginalny uchwyt i zwracamy warto undef.
     */
    if (!(s->error_log = ap_pfdopen(p, fd, "w"))) {
      s->error_log = original_log;
      XSRETURN_UNDEF;
    }

    /* Przekierowujemy strumie stderr rwnie do nowego dziennika bdw. */
    dup2(fileno(s->error_log), STDERR_FILENO);

  OUTPUT:
    RETVAL

char *
restore(s)
  Apache::Server s

  PREINIT:
    char *fname;

  CODE:
    /* Odtwarzamy zapamitany wczeniej uchwyt. */
    s->error_log = original_log;

    /* Odtwarzamy oryginaln warto stderr. */
    dup2(fileno(s->error_log), STDERR_FILENO);

    /* Dla wygody zwracamy nazw pliku dziennika bdw. */
    RETVAL = s->error_fname;

  OUTPUT:
    RETVAL
