package Cookbook::DivertErrorLog;

use DynaLoader ();
use Exporter ();

use strict;

our @ISA = qw(DynaLoader Exporter);

our @EXPORT_OK = qw(set_error_log restore_error_log);

our $VERSION = '0.01';

__PACKAGE__->bootstrap($VERSION);

use strict;

sub set_error_log {

  my $arg = shift;

  # Parametrem moe by nazwa pliku albo otwarty uchwyt pliku.
  # W obu przypadkach potrzebujemy deskryptora pliku.
  my $fd  = fileno($arg);

  unless (defined $fd) {
     open(OUT, ">$arg") or return;
     $fd = fileno(*OUT);
  }

  # Wywoujemy funkcj set() z moduu XS, przekazujc w parametrach
  # obiekt Apache::Server i deskryptor pliku.
  set(Apache->server, $fd);
}

sub restore_error_log {
  # Wywoujemy funkcj restore() z moduu XS, przekazujc jako parametr
  # obiekt Apache::Server.

  restore(Apache->server);
}
1;
