package Cookbook::SiteLog;

use Apache::Constants qw(OK);

use DBI;
use Time::HiRes qw(time);

use strict;

sub handler {

  my $r = shift;

  my $user  = $r->dir_config('DBUSER');
  my $pass  = $r->dir_config('DBPASS');
  my $dbase = $r->dir_config('DBASE');

  my $dbh = DBI->connect($dbase, $user, $pass,
   {RaiseError => 1, AutoCommit => 1, PrintError => 1}) or die $DBI::errstr;

  # Zbieramy dane o daniu i umieszczamy je w mapie.
  my %columns = ();

  $columns{waittime}   = time - $r->pnotes("REQUEST_START");
  $columns{status}     = $r->status;
  $columns{bytes}      = $r->bytes_sent;
  $columns{browser}    = $r->headers_in->get('User-agent');
  $columns{filename}   = $r->filename;
  $columns{uri}        = $r->uri;
  $columns{referer}    = $r->headers_in->get('Referer');
  $columns{remotehost} = $r->get_remote_host;
  $columns{remoteip}   = $r->connection->remote_ip;
  $columns{remoteuser} = $r->user;
  $columns{hostname}   = $r->get_server_name;
  $columns{encoding}   = $r->headers_in->get('Accept-Encoding');
  $columns{language}   = $r->headers_in->get('Accept-Language');
  $columns{pid}        = $$;

  # Tworzymy zapytanie SQL.
  my $fields = join "$_,", keys %columns;
  my $values = join ', ', ('?') x values %columns;

  my $sql = qq(
    insert into www.sitelog (hit, servedate, $fields)
    values (hitsequence.nextval, sysdate, $values)
  );

  my $sth = $dbh->prepare($sql);

  $sth->execute(values %columns);

  $dbh->disconnect;

  return OK;
}
1;
