package Cookbook::ErrorsToIRC;

use Apache::Constants qw(OK);
use Apache::File;

use Cookbook::DivertErrorLog qw(set_error_log restore_error_log);

use Net::IRC ();
use Sys::Hostname ();

our ($irc, $host);

use strict;

sub handler {

  my $r = shift;

  # Tworzymy tymczasowy plik, aby przechowa komunikaty dla tego dania.
  my $fh = Apache::File->tmpfile;

  # Zapisujemy uchwyt pliku na pniej.
  $r->pnotes(ERROR_HANDLE => $fh);

  # Rejestrujemy nasz podprogram, jeeli moemy przekierowa strumie
  # komunikatw o bdach do naszego pliku.
  $r->register_cleanup(\&send_to_irc) if set_error_log($fh);

  return OK;
}

sub send_to_irc {

  my $r = shift;

  my $irc_host = $r->dir_config('IRCHost') || 'localhost';

  $irc  ||= Net::IRC->new();
  $host ||= Sys::Hostname::hostname();

  # Odtwarzamy oryginalny dziennik bdw, aby ewentualne bdy,
  # ktre mogyby si teraz pojawi, zostay zarejestrowane.
  my $error_log = restore_error_log;

  # Pobieramy uchwyt pliku, zapamitany wczeniej.
  my $fh = $r->pnotes('ERROR_HANDLE');

  seek($fh, 0, 0); # Powrt na pocztek pliku.

  # Otwieramy poczenie z serwerem IRC i wysyamy zarejestrowane komunikaty.
  # Wicej szczegw na temat poczenia w dokumentacji moduu Net::IRC.
  my $conn = $irc->newconn(Nick    => "log-$$",
                           Server  => $irc_host,
                           Port    =>  6667,
                           Ircname => "Apache Log Bot $$ dla serwera $host");
  $conn->add_global_handler('376', \&on_connect);
  $irc->do_one_loop;

  $conn->privmsg('#logs', ('Dziennik bdw dla adresu URI', $r->uri));

  while (my $line = <$fh>) {
    $conn->privmsg('#logs', $line);
  }

  $conn->quit();

  return OK;
}

sub on_connect {
  # Funkcja, wywoywana zwrotnie przez obiekt Net::IRC.

  my $self = shift;

  $self->join('#logs');
}
1;
