package Cookbook::XMLtoHTML;

use Apache::Constants qw(NOT_FOUND SERVER_ERROR OK);

use XML::LibXML;
use XML::LibXSLT;

use strict;

# Moemy korzysta z tych samych obiektw dla wszystkich da.
my ($parser, $xslt);

sub handler ($$) {

  my ($class, $r) = @_;

  my ($source, $style_doc, $stylesheet);

  # Inicjalizujemy analizatory XML i XSLT.
  $parser ||= XML::LibXML->new;
  $xslt   ||= XML::LibXSLT->new;

  my $filename = $r->filename;

  # Jeeli danie dotyczy pliku .html, zmieniamy rozszerzenie na .xml.
  $filename =~ s/\.html$/.xml/;

  eval { $source = $parser->parse_file($filename) }
    or return NOT_FOUND;

  # Szukamy pliku .xsl dla dokumentu.
  # Jeeli nie istnieje arkusz XSL o nazwie odpowiadajcej dokumentowi,
  # uywamy arkusza default.xsl w tym samym katalogu.
  $filename =~ s/\.xml$/.xsl/;
  $filename =~ s![^/]+$!default.xsl! unless -f $filename;

  eval { $style_doc = $parser->parse_file($filename) }
    or return NOT_FOUND;

  eval { $stylesheet = $xslt->parse_stylesheet($style_doc) }
    or return SERVER_ERROR;

  my $results = $stylesheet->transform($source);

  $r->send_http_header('text/html');
  $r->print($stylesheet->output_string($results));

  return OK;
}
1;
