package Cookbook::TextTemplate;

use Apache::Constants qw(OK DECLINED SERVER_ERROR);
use Apache::File;
use Apache::Log;

use Text::Template;

use strict;

sub handler {
 
  my $r = shift;
  my $log = $r->server->log;

  return DECLINED unless $r->content_type eq 'text/html';

  # Definiujemy znaczniki otwierajce i zamykajce.
  my $open = $r->dir_config('TemplateOpen') || "[--";
  my $close = $r->dir_config('TemplateClose') || "--]";

  # Pobieramy dany zasb.
  my $fh = Apache::File->new($r->filename);

  unless ($fh) {
    $log->warn("Nie mona otworzy pliku - pomijamy... $!");
    return DECLINED;
  }

  # Pobieramy wartoci, ktrych uyjemy do wypenienia szablonu.
  # $elements powinno stanowi referencj do mapy, jeeli istnieje.
  my $elements = $r->pnotes('ELEMENTS');

  if ($elements && ref $elements ne 'HASH') {
    $log->error("Podaj wartoci do wypenienia szablonu w mapie.");
    return SERVER_ERROR;
  }

  # Przekazujemy moduowi Text::Template szablon (czyli dany plik) jako tekst.
  my $template = new Text::Template (TYPE => 'STRING',
                                     SOURCE => do {local $/; <$fh>},
                                     DELIMITERS => [$open, $close]);

  unless ($template) {
    $log->error("Nie mona utworzy szablonu: ", $Text::Template::ERROR);
    return SERVER_ERROR;
  }

  # Jawna kompilacja szablonu nie jest wymagana, ale w ten
  # sposb moemy dosta komunikaty o ewentualnych bdach.
  my $compile = $template->compile;

  unless ($compile) {
    $log->error("Nie mona skompilowa szablonu: ", $Text::Template::ERROR);
    return SERVER_ERROR;
  }

  # Wypeniamy szablon danymi z mapy.
  my $error;

  my $result = $template->fill_in(BROKEN => sub { my %args = @_;
                                                  my $ref  = $args{arg};
                                                  $$ref    = $args{error};
                                                  return; },
                                  BROKEN_ARG => \$error,
                                  HASH => $elements);

  unless ($result) {
    $log->error("Nie mona wypeni szablonu: ", $error);
    return SERVER_ERROR;
  }

  # Wysyamy wypenion stron do klienta.
  $r->send_http_header('text/html');
  print $result;

  return OK;
}
1;
