package Cookbook::TaintRequest;

use Apache;
use Apache::Util qw(escape_html);

# Nie uda si zaadowa moduu, jeeli nie opcja PerlTaintChceck bdzie wyczona.
use Taint qw(tainted);

use strict;

@Cookbook::TaintRequest::ISA = qw(Apache);

sub new {

  my ($class, $r) = @_;

  $r ||= Apache->request;

  tie *STDOUT, $class, $r;

  return tied *STDOUT;
}

sub print {

  my ($self, @data) = @_;

  foreach my $value (@data) {
    # Dereferencja skalarnych referencji.
    $value = $$value if ref $value eq 'SCALAR';

    # Kodujemy niebezpieczne znaki, jeeli dane s "podejrzane".
    $value = escape_html($value) if tainted($value);
  }

  $self->SUPER::print(@data);
}

sub TIEHANDLE {

  my ($class, $r) = @_;

  return bless { r => $r }, $class;
}

sub PRINT {
  shift->print(@_);
}
1;
