package Cookbook::RSS;

use Apache::Constants qw(OK DECLINED);
use XML::RSS;

use strict;

sub handler {

  my $r = shift;

  my $filename = $r->filename;

  return DECLINED unless $filename =~ m/\.rss$/;

  my $rss = XML::RSS->new;

  if (-f $filename) {
    # Wczytujemy plik RDF z dysku.
    $rss->parsefile($filename);
  }
  else {
    # Nie ma pliku RDF, tworzymy kana podstawowy.
    $rss->channel(title       => 'mod_perl - kompendium programisty',
                  link        => 'http://www.modperlcookbook.org/',
                  description => 'rdo rozwiza dla moduu mod_perl',
                 );
  }

  $rss->add_item(title       => 'mod_perl - zasoby',
                 link        => 'http://www.modperlcookbook.org/resources/',
                 description => 'Wicej zasobw i porad dla moduu mod_perl',
                );

  $rss->add_item(title       => 'Przykadowe rozwizania',
                 link        => 'http://www.modperlcookbook.org/code/',
                 description => 'Przykadowe rozwizania dla moduu mod_perl',
                );

  $r->send_http_header('text/xml');
  $r->print($rss->as_string, "\n");

  return OK;
}
1;
