package Cookbook::LogChart;

use Apache::Constants qw(OK SERVER_ERROR);

use DBI;
use GD::Graph::bars;

use strict;

sub handler {
  # Pobieramy statystyki z dziennika dostpu w bazie danych
  # dla okrelonej daty i tworzymy wykres supkowy dla liczby
  # odwiedzin w poszczeglnych godzinach.

  my $r = shift;

  # Pobieramy dat.
  (my $date = $r->path_info) =~ s!^/!!;

  # Sprawdzamy format daty.
  unless ($date =~ m/\d{4}-\d{2}-\d{2}/) {
    $r->log_error('Data musi by w formacie RRRR-MM-DD');
    return SERVER_ERROR;
  }

  my $user  = $r->dir_config('DBUSER');
  my $pass  = $r->dir_config('DBPASS');
  my $dbase = $r->dir_config('DBASE');

  # Pobieramy dane z bazy. Przyjmujemy, e zainstalowany jest
  # PerLogHandler podobny do opisanego w zadaniu 16.1.
  my $dbh = DBI->connect($dbase, $user, $pass,
   {RaiseError => 1, AutoCommit => 1, PrintError => 1}) or die $DBI::errstr;

  # Modu GD::Graph oczekuje listy wartoci dla osi x.
  my $sql= qq(
    select to_char(servedate, 'HH24') hour, count(*) total
      from sitelog
      where trunc(servedate) = to_date(?, 'YYYY-MM-DD')
      group by to_char(servedate, 'HH24')
      order by hour
  );

  my $sth = $dbh->prepare($sql);

  $sth->execute($date);

  my $rows = $sth->fetchall_arrayref;

  # Pobieramy dane.
  my ($x, $y);

  foreach my $row (@$rows) {
    push @$x, @$row[0];
    push @$y, @$row[1];
  }

  # Tworzymy obiekt GD::Graph...
  my $graph = GD::Graph::bars->new;

  # ...i ustawiamy tytu oraz opisy osi.
  $graph->set(x_label          => 'Godzina',
              y_label          => 'Liczba odwiedzin',
              title            => "Odwiedziny w dniu $date",
              bar_spacing      => 4,
              x_label_position => 0.5,
             );

  # Rysujemy wykres.
  my @data = ($x, $y);
  unless ($graph->plot(\@data)) {
    $r->warn($graph->error);
    return SERVER_ERROR;
  }

  # Wysyamy dane do przegldarki z odpowiednimi nagwkami.
  $r->send_http_header('image/png');

  binmode STDOUT;    # bardzo wane w systemie Win32

  $r->print($graph->gd->png);

  return OK;
}
1;
