package Cookbook::EmailUploads;

use Apache::Constants qw(OK SERVER_ERROR);
use Apache::Request;

use Cookbook::Mail qw(send_mail);

use strict;

sub handler {

  my $r = Apache::Request->new(shift, DISABLE_UPLOADS => 0);

  # Jeeli nie ma demona sendmail, musimy (tu i poniej) poda nazw serwera SMTP.
  # my $smtp_host = 'my.smtp.host';

  my $upload = $r->upload;
  my %attachment;

  if ($upload) {
    # Wysamy list.
    my ($name) = $upload->filename =~ m!([^/\\]*$)!;

    %attachment = (file => $upload->tempname,
                   name => $name);

    send_mail($r, From => $r->server->server_admin,
                To => $r->param('to'),
                Subject => $r->param('subject'),
                Data => $r->param('message'),
                # smtp_host => $smtp_host,
                attachment => \%attachment,
            ) or return SERVER_ERROR;

    print <<HERE;
      <html>
        <body>
          List zosta wysany.
        </body>
      </html>
HERE
  }
  else {
    # Tworzymy formularz WWW.
    print <<HERE;
      <html>
        <body>
          <b>Wysyanie listu z zacznikiem...</b>
          <form method="post" enctype="multipart/form-data">
            Do:<input type="text" name="To" size="24"><br/>
            Tytu:<input type="text" name="subject" size="24"><br/>
            Zacznik:<input type="file" name="upload" size="16"><br/>
            Tre:</br>
            <textarea name="message" cols="40" rows="4"></textarea><br/>
            <input type="submit"><br/>
          </form>
        </body>
      </html>
HERE
  }
}
1;
