#!/usr/bin/perl -w
use CPAN;

use strict;

# Pobieramy plik i wydobywamy z niego nazw dystrybucji.
my $file = $ARGV[0];
open (FILE, $file) or error_message("Nie mona otworzy pliku '$file': $!");
chomp(my $dist = <FILE>);
close FILE or error_message("Nie mona zamkn pliku '$file': $!");

# Sprawdzamy, czy nazwa dystrybucji wyglda poprawnie.
error_message("$dist nie jest poprawn nazw dystrybucji!")
  unless $dist =~ m!^[/+\-.@\w]+\.(tar\.gz|tgz|zip)$!;

# Ostatnia szansa, by si wycofa...
print "\n\nPrzygotowanie do instalacji dystrybucji $dist\n\n";
print "Prosz nacisn Control-C, aby przerwa...\n";
sleep(7);

# Instalujemy dystrybucj.
CPAN::Shell->install($dist);

# Czekamy, a uytkownik nacinie Enter i koczymy dziaanie.
print "\nProsz nacisn Enter, aby zamkn okno.";
my $ans = <STDIN>;

sub error_message {
  my $message = shift;
  warn "\n $message \n";
  sleep(10);
  die;
}
