package CacheHTML;

use strict;
use Apache::Constants qw(OK SERVER_ERROR DECLINED);
use Apache::File ();

sub fixup_handler ($$) {
  my ($self, $r) = @_;

  my $timeout = 1440 / $self->ttl($r);

  my $file = $r->filename();

  # sprawdzamy czas utworzenia pliku..

  if (-f $file && -M _ < $timeout) {
    print STDERR "uywam pliku cache $file\n";
    return(DECLINED);
  }

  print STDERR "tworze plik $file\n";
  my $fake_r = CacheHTML::Apache->new($r);

  # Wywoujemy metod handler() podklasy, ale z "faszywym" obiektem
  # dania, abymy mogli przej wygenerowan zawarto.
  $self->handler($fake_r);

  my $fh = Apache::File->new(">$file") || return(SERVER_ERROR);
  print $fh $fake_r->data();
  $fh->close;

  # Wreszcie ustawiamy nazw pliku na plik buforujcy i pozwalamy
  # domylnemu programowi obsugi serwera Apache wysa jego zawarto.

  $r->filename($file);
  return OK;
}

sub ttl {
  return (60);
}


# przykadowa procedura obsugi
# musi by przeciona
sub handler ($$) {
  my ($self, $r) = @_;

  $r->send_http_header('text/html'); # ignorujemy..

  $r->print(" --- metoda nie jest przeciona ----");

}


# w tej klasie przechwytujemy wynik dziaania programu obsugi i zapamitujemy go.
package CacheHTML::Apache;

use base qw(Apache);

sub new {
  my ($class, $r) = @_;

  $r ||= Apache->request;

  return bless { r => $r, data=>undef }, $class;
}

sub print {
  shift->{data} .= join('', @_);
}

sub send_http_header {};

sub data {
  return shift->{data};
}

1;
