package Cookbook::DefaultLogin;

use Apache::Constants qw (OK DECLINED);

use MIME::Base64 ();
use Socket qw (sockaddr_in inet_ntoa);

use strict;

sub handler {

  my $r = shift;
  my $c = $r->connection;
  
  # Przetwrz nagwek samodzielnie.
  my $auth_header = $r->headers_in->get('Authorization');
  my $credentials = (split / /, $auth_header)[-1];
  my ($user, $passwd) = split /:/, MIME::Base64::decode($credentials), 2;
  
  # Nazwa uytkownika musi by zapisana maymi literami.
  $user = lc($user);
  
  # Automatyczne logowanie dla uytkownika guest lub z lokalnego 
  # komputera (uatwia testowanie za pomoc programu telnet).
  my $local_ip = inet_ntoa((sockaddr_in($c->local_addr))[1]);
  
  if ($user eq 'guest' || $c->remote_ip eq $local_ip) {
    $user   = $r->dir_config->get('DefaultUser');
    $passwd = $r->dir_config->get('DefaultPassword');
  }
  
  return DECLINED unless $user; # nie ma nic do roboty...
  
  # Pocz nazw uytkownika i haso i ustaw nagwek dania.
  $credentials = MIME::Base64::encode(join(':', $user, $passwd));
  
  $r->headers_in->set(Authorization => "Basic $credentials");
  
  return OK;
}
1;
