package My::AuthHandler;

use Apache::Constants qw (OK FORBIDDEN);

use Cookbook::CookieAuthentication;
use My::Utils qw(authenticate_user); # jaki fikcyjny pakiet narzdziowy

use strict;

sub handler {

  my $r = Cookbook::CookieAuthentication->new(shift);

  # Przepu, jeeli jest to danie wewntrzne.
  return OK unless $r->is_initial_req;
  
  # Pobierz dane dostarczone przez klienta.
  my ($status, $password) = $r->get_cookie_auth_pw;
  
  return $status unless $status == OK;
  
  # Przeprowad wasne sprawdzenie uytkownika i hasa.
  return OK if authenticate_user($r->user, $password);
  
  # Ojej, ze haso.
  $r->note_cookie_auth_failure;
  return FORBIDDEN;
}
1;
