package Cookbook::SSI;

use Apache::SSI;

use HTTP::Request;
use LWP::UserAgent;

use strict;

@Cookbook::SSI::ISA = qw(Apache::SSI);

sub ssi_include {
  # Zmieniamy implementacj znacznika SSI 'include' tak, aby
  # jego wynik mona byo filtrowa moduem Apache::Filter.
  # W tej wersji obsugujemy tylko znaczniki <!--#include virtual="plik"-->.

  my ($self, $args) = @_;

  return $self->error("Znacznik musi mie typ 'virtual'")
    unless $args->{virtual};

  # Tworzymy adres URI do naszego dokumentu.
  my $uri = Apache::URI->parse(Apache->request);

  # Nastpnie dodajemy ciek adresu URI na podstawie znacznika SSI.
  if ($args->{virtual} =~ m!^/!) {
    # cieka jest bezwzgldna.
    $uri->path($args->{virtual});
  }
  else {
    # cieka jest wzgldem aktualnego dokumentu.
    my ($base) = $uri->path =~ m!(.*/)!;

    $uri->path($base . $args->{virtual});
  }

  my $request = HTTP::Request->new(GET => $uri->unparse);

  my $response = LWP::UserAgent->new->request($request);

  return $self->error("Nie mona wczy wirtualnego adresu URL")
    unless $response->is_success;

  # Zwracamy zawarto z powrotem do moduu Apache::SSI.
  return $response->content;
}
1;
