package Cookbook::Registry;

use Apache::Constants qw(OK NOT_FOUND);
use Apache::RegistryNG;

use strict;

@Cookbook::Registry::ISA = qw(Apache::RegistryNG);

sub sub_wrap {
  # Pozwalamy skryptom rodowiska Registry uywa skadni programw obsugi.

  my($pr, $code, $package) = @_;

  $code    ||= $pr->{'code'};
  $package ||= $pr->{'namespace'};

  # Zamieniamy identyfikator moduu na wygenerowany przez klas Apache::Registry.
  (my $sub = $$code) =~ s/^(package ).*;/$1$package;/;

  $pr->{'sub'} = \$sub;
}

sub can_compile {
  # Sprawdzamy tylko, czy plik mona czyta i czy jest niepusty.

  my $pr = shift;
  my $r = $pr->{r};

  if (-r $r->finfo && -s _) {
    $pr->{'mtime'} = -M _;
    return OK;
  }

  $r->log_error($r->filename, " nie znaleziono lub nie mona odczyta.");
  return NOT_FOUND;
}

sub run {

  my ($pr, @args) = @_;

  # Pobieramy warto zwrcon przez modu Apache::RegistryNG i nasz program obsugi.
  my ($ng_rc, $rc) = shift->SUPER::run(@args);

  # Jeeli modu RegistryNG zwrci OK, zwracamy warto z naszego programu obsugi.
  return ($ng_rc == OK) ? $rc : $ng_rc;
}
1;
