package Cookbook::SimpleStat;

use Apache::Constants qw(OK);

use strict;

# Tworzymy globaln map, w ktrej przechowamy czasy modyfikacji moduw.
my %stat = ();

sub handler {

  my $r = shift;

  # Przegldamy map %INC i przeadowujemy kady plik.
  foreach my $key (keys %INC) {

    # Pobieramy czas modyfikacji pliku.
    my $file = $INC{$key};
    my $mtime = (stat $file)[9];

    next unless defined $mtime && $mtime;

    # Domylna warto to czas zaadowania _tego_ moduu
    # (czyli w przyblieniu moment startu serwera).
    $stat{$file} = $^T unless defined $stat{$file};

    if ( $mtime > $stat{$file} ) {
      local $^W;  # lokalnie wyczamy generowanie ostrzee...

      # Przeadowanie pliku.
      delete $INC{$key};
      eval { require $file };

      $r->server->log->warn("Proces $$ nie mg przeadowa pliku $file! $@") if $@;

      # Zapisujemy nowy czas zaadowania.
      $stat{$file} = $mtime;
    }
  }

  return OK;
}
1;
