package Cookbook::ViewConf;

use Apache::Constants qw(OK SERVER_ERROR NOT_FOUND);
use Apache::File;

use strict;

sub handler {

  my $r = shift;

  # Pobieramy nazw danego pliku.
  my $file = $r->filename;

  # Upewniamy si, e istnieje.
  unless (-f $r->finfo) {
    $r->log_error("Plik $file nie istnieje.");
    return NOT_FOUND;    
  }

  # Otwieramy uchwyt pliku.
  my $fh = Apache::File->new($file);

  unless ($fh) {
    $r->log_error("Nie mona otworzy pliku $file: $!");
    return SERVER_ERROR;
  }

  $r->send_http_header('text/plain');

  # Pobieramy rozmiar pliku i wysyamy go.
  my $size = -s _;
  my $sent = $r->send_fd($fh);

  $r->print(<<"END");

----------------------------------------------------
Rozmiar pliku: $size
Wysano bajtw: $sent
----------------------------------------------------

END

  return OK;
}
1;
