package Cookbook::SendSmart;

use Apache::Constants qw( OK NOT_FOUND );
use Apache::File;

use File::MMagic;
use IO::File;

use strict;

sub handler {
  # Wysyamy plik statyczny z odpowiednimi nagwkami tylko, kiedy
  # klient posiada star wersj.

  my $r = shift;

  # Nie Apache::File->new() poniewa File::MMagic potrzebuje $fh->seek().
  my $fh = IO::File->new($r->filename);
 
  return NOT_FOUND unless $fh;
 
  # "Magicznie" ustawiamy typ MIME.
  $r->content_type(File::MMagic->new->checktype_filehandle($fh));
 
  # Ustawiamy nagwek Last-Modified na podstawie czasu modyfikacji pliku...
  $r->set_last_modified((stat $r->finfo)[9]);

  # ...oraz nagwki Etag i Content-Length.
  $r->set_etag;
  $r->set_content_length;
 
  # Jeeli wszystkie warunki z nagwkw If-* s spenione, wysyamy nagwki.
  # W przeciwnym razie zwracamy status do serwera Apache.
  if ((my $status = $r->meets_conditions) == OK) {
    $r->send_http_header;
  }
  else {
    return $status;
  }
 
  # Ustawiamy wskanik pliku na pocztek i wysyamy zawarto.
  seek $fh, 0, 0;
  $r->send_fd($fh);
 
  return OK ;
}
1;
