package Cookbook::SendIcon;

use Apache::Constants qw(OK SERVER_ERROR);
use Apache::File;

use DirHandle;

use strict;

sub handler {

  my $r = shift;

  # Pobieramy pooenie podkatalogu icons/ wzgldem ServerRoot.
  my $icons = $r->server_root_relative('icons');
  my $dh = DirHandle->new($icons);
  unless ($dh) {
    $r->log_error("Nie mona otworzy katalogu $icons: $!");
    return SERVER_ERROR;
  }

  # Pobieramy zawarto katalogu i dodajemy do listy @icons wszystkie znalezione
  # pliku typu GIF.
  my @icons;

  foreach my $icon ($dh->read) {
    my $sub = $r->lookup_uri("/icons/$icon");
    next unless $sub->content_type eq 'image/gif';
    push @icons, $sub->filename;
  }

  # Wybieramy losowy obraz.
  my $image = $icons[rand @icons];

  # Otwieramy wybrany plik obrazu i wysyamy go klientowi.
  my $fh = Apache::File->new($image);
  unless ($fh) {
    $r->log_error("Nie mona otworzy pliku $image: $!");
    return SERVER_ERROR;
  } 

  binmode $fh;  # wymagane dla systemw Win32

  $r->send_http_header('image/gif');

  $r->send_fd($fh);

  # Oprniamy bufor, aby obraz zosta wysany natychmiast.
  $r->rflush;

  # Symulujemy jaki dugotrway proces...
  sleep(5);

  return OK;
}
1;
