package Cookbook::SendAnyDoc;

use Apache::Constants qw(OK NOT_FOUND);
use Apache::File;

use DBI;
use DBD::Oracle;
use MIME::Types qw(by_suffix);
use Time::Piece;

use strict;

sub handler {

  my $r = shift;

  my $user  = $r->dir_config('DBUSER');
  my $pass  = $r->dir_config('DBPASS');
  my $dbase = $r->dir_config('DBASE');

  # Tworzymy obiekt Time::Piece na pniej.
  my $time = localtime;

  my $dbh = DBI->connect($dbase, $user, $pass,
   {RaiseError => 1, AutoCommit => 1, PrintError => 1}) || die $DBI::errstr;

  # Znajdujemy nazw tablicy i pliku w dodatkowej informacji w ciece.
  # Przykadowy adres URI: http//localhost/SendAnyDoc/docs/file.pdf
  my ($table, $filename) = $r->path_info =~ m!/(.*)/(.*)!;

  # Tworzymy zapytanie, ktre zwraca zawarto pliku i czas ostatniej modyfikacji
  # w sekundach od pocztku epoki, ale wzgldem aktualnej strefy czasowej
  # (inaczej ni perlowa funkcja time()).
  my $sql= qq(
     select document,
       (last_modified - to_date('01011970','DDMMYYYY')) * 86400
     from $table
     where name = ?
  );

  # Specjalne ustawienia dla pl BLOB.
  $dbh->{LongReadLen} = 10 * 1024 * 1024;  # 10M

  my $sth = $dbh->prepare($sql);

  $sth->execute($filename);

  my ($file, $last_modified) = $sth->fetchrow_array;

  $sth->finish;

  return NOT_FOUND unless $file;

  # Informujemy przegldark, e akceptujemy dania fragmentw pliku.
  $r->headers_out->set('Accept-Ranges' => 'bytes');

  # Ustawiamy typ MIME na podstawie rozszerzenia nazwy pliku.
  $r->content_type(by_suffix($filename)->[0]);

  # Niech Apache zdecyduje, ktry czas jest najpniejszy:
  #   1. czas pobrany z bazy danych
  #   2. czas modyfikacji pliku rdowego moduu.
  # W przypadku czasu z bazy danych upewniamy si, ze jest w GMT.
  (my $package = __PACKAGE__) =~ s!::!/!g;
  $r->update_mtime($last_modified - $time->tzoffset);
  $r->update_mtime((stat $INC{"$package.pm"})[9]);
  $r->set_last_modified;

  # Sprawdzamy, czy jest to danie fragmentw _po_ ustawieniem Content-Length
  # ale _przed_ wysaniem nagwkw, gdy funkcja ap_set_byterange modyfikuje je.
  # Pamitajmy, e ustawienie Content-Length jest _konieczne_.
  $r->set_content_length(length($file));

  my $range_request = $r->set_byterange;

  # Tak albo nie.
  if ((my $status = $r->meets_conditions) == OK) {
    $r->send_http_header;
  }
  else {
    return $status;
  }

  # Nie wysyamy zawartoci, jeeli o ni nie proszono.
  return OK if $r->header_only;

  # Teraz zajmiemy si fragmentami pliku, w przypadku np. dokumentu PDF.
  if ($range_request) {
    while( my($offset, $length) = $r->each_byterange) {
      print substr($file, $offset, $length);
    }
  }
  else {
    print $file;
  }

  return OK ;
}
1;
