package Cookbook::ViewServer;

use Apache::Constants qw(OK);
use Apache::Log;

use strict;

sub handler {

  # Pobieramy obiekt dania...
  my $r = shift;

  # ...a z niego obiekt serwera.
  my $s = $r->server;

  $r->send_http_header('text/plain');

  # Przegldamy wszystkie skonfigurowane serwery.
  for (my $s = Apache->server; $s; $s = $s->next) {
    print "Dyrektywa User:        ", $s->uid,             "\n";
    print "Dyrektywa Group:       ", $s->gid,             "\n";
    print "Dyrektywa Port:        ", $s->port,            "\n";
    print "Dyrektywa TimeOut:     ", $s->timeout,         "\n";
    print "Dyrektywa ErrorLog:    ", $s->error_fname,     "\n";
    print "Dyrektywa LogLevel:    ", $s->loglevel,        "\n";
    print "Dyrektywa ServerName:  ", $s->server_hostname, "\n";
    print "Dyrektywa ServerAdmin: ", $s->server_admin,    "\n";

    print "Dyrektywy ServerAlias:\n" if $s->is_virtual;
    print "\t$_\n" foreach @{$s->names};
    print "-" x 30,                                       "\n";
  }

  return OK;
}
1;
