package Cookbook::TraceError;

use Apache::Constants qw(OK SERVER_ERROR DECLINED);
use Apache::Log;

use strict;

sub handler {
  # Wczamy opcje pomocne przy wyszukiwaniu bdw i ponownie uruchamiamy danie.
  # Do uycia w programie obsugi PerlCleanupHandler.

  my $r = shift;

  # Nic nie robimy, chyba e to danie gwne, ktre zakoczyo si bdem.
  return DECLINED unless $r->is_initial_req &&
                         $r->status == SERVER_ERROR;

  # Zapamitujemy poprzedni warto LogLevel i ustawiamy now.
  my $old_loglevel = $r->server->loglevel(Apache::Log::DEBUG);

  # Dodatkowe ledzenie.
  my $old_trace = DBI->trace(2);

  # Tworzymy danie testowe.
  my $sub = $r->lookup_uri($r->uri);

  # run() normalnie wysya dane do klienta, ale poniewa jestemy
  # ju w fazie sprztania, poczenie zostao zamknite.
  $sub->run;

  # Odtwarzamy poprzednie wartoci, inaczej zmiany 
  # wpyn na przetwarzanie kolejnych da.
  DBI->trace($old_trace);
  $r->server->loglevel($old_loglevel);

  return OK;
}
1;
