package Cookbook::ErrorsToBrowser;

# Wypisujemy N ostatnich wierszy z dziennika bdw.
# Przyda si to przy wyszukiwaniu bdw w naszym kodzie.

use Apache::Constants qw(OK);
use Apache::File;

use strict;

sub handler {

  my $r = shift;

  my $lines = $r->dir_config('ErrorLines') || 5;

  # Upewniamy si, e mamy ciek bezwzgldn.
  my $error_log = $r->server_root_relative($r->server->error_fname);

  my $fh = Apache::File->new($error_log);

  my @lines;

  while (my $line = <$fh>) {
    shift @lines if (push @lines, $line) > $lines;
  }

  $r->send_http_header('text/plain');
  print @lines;

  return OK;
}
1;
