package Cookbook::DBIUtils;

use strict;

use Exporter;

our @ISA = qw(Exporter);
our @EXPORT_OK = qw(dbh_terminate);

sub dbh_terminate {
  # Podprogram oparty na metodach connect() z Apache::DBI i DBI.
  # Idea polega na znalezieniu identyfikatora poczenia i usuniciu
  # go z puli buforowanych pocze.

  # Ta cz jest ukradziona z DBI->connect().
  # Pamitajmy, e Apache::DBI->connect() nigdy nie jest wywoywane
  # bezporednio; parametry otrzymuje z DBI.pm. Musimy wic zrekonstruowa
  # identyfikator poczenia, ktry mg dosta modu Apache::DBI.
  my $arg = shift;
  $arg =~ s/^dbi:\w*?(?:\((.*?)\))?://i
    or '' =~ /()/;
  my $driver_attrib_spec = $1;
  unshift @_, $arg;
  
  my @args = map { defined $_ ? $_ : "" } @_;

  $driver_attrib_spec = { split /\s*=>?\s*|\s*,\s*/, $driver_attrib_spec }
    if $driver_attrib_spec;

  my $attr = {
          PrintError=>1, AutoCommit=>1,
          ref $args[3] ? %{$args[3]} : (),
          ref $driver_attrib_spec ? %$driver_attrib_spec : (),
         };

  # Ta cz pochodzi z Apache::DBI->connect(), generujemy tu klucz,
  # ktry Apache::DBI wie z aktualnym poczeniem.
  my $Idx = join $;, $args[0], $args[1], $args[2];
  
  while (my ($key,$val) = each %{$attr}) {
    $Idx .= "$;$key=$val";
  }
  
  # Kiedy mamy ju identyfikator poczenia, moemy pobra wewntrzn
  # map, ktrej Apache::DBI uywa do buforowania pocze.
  my $handlers = Apache::DBI->all_handlers;
  
  my $r = Apache->request;

  if ($handlers->{$Idx}) {
    $r->warn("Zamykanie poczenia...");
    
    unless (delete $handlers->{$Idx}) {
      $r->log_error("Nie mona zamkn poczenia $Idx");
      return;
    }
  }
  else {
    $r->log_error("Nie mona znale poczenia $Idx");
    return;
  }

  return 1;
}
1;
