package Cookbook::CheckConnection;

use IO::Select;

use strict;

sub client_connected {

  my $c = Apache->request->connection;

  # Najpierw sprawdzamy, czy Apache wykry ju zerwanie tradycyjnym sposobem.
  return if $c->aborted;

  # A teraz prawdziwy test.
  # Sprawdzamy, czy moemy czyta z pliku wyjciowego.
  my $s = IO::Select->new($c->fileno);

  return if $s->can_read(0);

  # Wyglda, e klient czeka cierpliwie...
  return 1;
}
1;
