package Cookbook::Regex;

use Apache::Constants qw( :common );
use Apache::File;
use Apache::Log;

use strict;

sub handler {
  
  my $r = shift;

  my $log = $r->server->log;

  my @change = $r->dir_config->get('RegexChange');
  my @to     = $r->dir_config->get('RegexTo');
 
  unless ($r->content_type eq 'text/html') {
    $log->info("danie nie dotyczy dokumentu HTML - pomijamy...");
    return DECLINED; 
  }

  unless (@change && @to) {
    $log->info("Nie ustawiono parametrw - pomijamy...");
    return DECLINED; 
  }

  if (@change != @to) {
    $log->error("Nie zgadza si liczba termw w wyraeniach regularnych!");
    return SERVER_ERROR;
  }

  my $fh = Apache::File->new($r->filename);

  unless ($fh) {
    $log->warn("Nie mona otworzy dania - pomijamy... $!");
    return DECLINED;
  }

  $r->send_http_header('text/html');

  while (my $output = <$fh>) {
    for (my $i=0; $i < @change; $i++) {    
      $output =~ s/$change[$i]/$to[$i]/eeg;
    }
    print $output;
  }

  return OK;
}
1;
