package Cookbook::GetCookie;

use Apache::Constants qw(OK);
use Apache::Cookie;
use Apache::Request;

use strict;

sub handler {

  my $r = Apache::Request->new(shift);

  my %cookiejar = Apache::Cookie->new($r)->parse;

  $r->send_http_header('text/plain');

  foreach my $cookie (keys %cookiejar) {
    $r->print($cookiejar{$cookie}->name, " => ",
              $cookiejar{$cookie}->value, "\n");
  }

  return OK;
}
1;
