package Cookbook::EchoHeaders;

use Apache::Constants qw (OK);

use strict;

sub handler {

  my $r = shift;
  
  # Pobieramy wszystkie nagwki naraz...
  my %headers_in = $r->headers_in;

  # ...albo po jednym i co z nimi robimy...
  my $gzip = $r->headers_in->get('Accept-Encoding') =~ m/gzip/;

  $r->send_http_header('text/plain');

  print "Serwer w adresie URL to: ", $headers_in{'Host'}, "\n";
  print "Twoja przegldarka to: ",   $headers_in{'User-Agent'}, "\n";
  print "Twoja przegldarka obsuguje dane skompresowane programem gzip\n" if $gzip;

  return OK;
}

1;
