#!/bin/ksh

# Uaktualnienie serwera Apache i moduu mod_perl.
# Zainstalowa w pliku crontab uytkownika root.
#
# Rezultatem jest plik zawierajcy podsumowanie
# zmian w kodzie rdowym moduu mod_perl i serwera
# Apache, wysyany do nas e-mailem.

source="/cieka/do/kodu/rdowego"
email="nasz@adres.emailowy"
  
/usr/local/apache/bin/apachectl stop

cd $source/modperl
make install

>/usr/local/apache/logs/error_log

/usr/local/apache/bin/apachectl start

sleep 10
today=`date +%b" "%d", "%Y`
  
cd $source/modperl
echo "\n---- Zmiany w module mod_perl ----" > Changes.diff
diff -u Changes.old Changes >> Changes.diff

cd $source/apache-1.3/src
echo "\n---- Zmiany w serwerze Apache ----" > Changes.diff
diff -u CHANGES.old CHANGES >> Changes.diff

cat /usr/local/apache/logs/error_log \
  $source/modperl/Changes.diff \
  $source/apache-1.3/src/Changes.diff \
  | mail -s "httpd $today" $email
