package Cookbook::ReduceStats;

use Apache::Constants qw(OK DECLINED DECLINE_CMD);
use Apache::ModuleConfig ();

use 5.006;
use DynaLoader ();
use strict;

our $VERSION = '0.01';
our @ISA = qw(DynaLoader);

__PACKAGE__->bootstrap($VERSION);

use strict;

sub handler {

  my $r = shift;

  my $cfg = Apache::ModuleConfig->get($r, __PACKAGE__);

  my $uri = $r->uri;

  # Zezwalamy na tumaczenie, jeeli adres URI pasuje do jednej z dyrektyw Alias...
  return DECLINED if grep { $uri =~ m/^$_/ } @{$cfg->{_alias}};

  # ...albo, gdy pasuje do wyraenia regularnego w dyrektywach AliasMatch.
  return DECLINED if grep { $uri =~ m/$_/ } @{$cfg->{_alias_match}};

  # Pozostae dyrektywy Location i LocationMatch nie potrzebuj nazwy pliku,
  # wic dla nich koczymy faz tumaczenia.
  return OK if grep { $uri =~ m/^$_/ } @{$cfg->{_location}};
  return OK if grep { $uri =~ m/$_/ } @{$cfg->{_location_match}};
  
  # Wszystkie pozostae adresy URI korzystaj z plikw, wic pozostawiamy je bez zmian.
  return DECLINED;
}

sub Alias ($$$$) {
  my ($cfg, $parms, $from, $to) = @_;

  if ($parms->info) {
    push @{$cfg->{_alias_match}}, qr/$from/
      unless grep /$from/, @{$cfg->{_alias_match}};
  }
  else {
    push @{$cfg->{_alias}}, $from
      unless grep /$from/, @{$cfg->{_alias}};
  }

  return DECLINE_CMD;
}

sub Location ($$$;*) {
  my ($cfg, $parms, $args, $fh) = @_;

  $args =~ s/>$//;  # pozbywamy si kocowego znaku >

  if ($parms->info || $args =~ m/~/ ) {
    (my $regex = $args) =~ s/~? *//;
    push @{$cfg->{_location_match}}, qr/$regex/
      unless grep /$regex/, @{$cfg->{_location_match}};
  }
  else {
    push @{$cfg->{_location}}, $args
      unless grep /$args/, @{$cfg->{_location}};
  }

  return DECLINE_CMD;
}

sub SERVER_CREATE {
  my $class = shift;
  my %self  = ();

  # Inicjalizujemy pola naszej klasy.
  for my $entry (qw(_alias _alias_match _location _location_match)) {
    $self{$entry} = [];
  }

  return bless \%self, $class;
}

sub SERVER_MERGE {
  my ($parent, $current) = @_;
  my %new = (%$parent, %$current);

  return bless \%new, ref($parent);
}
1;
