#ifndef DRIVER_H
#define DRIVER_H


struct EthernetDriverInfo{
  char name[64];
  char description[1024];
};

/* Zwraca nazwę i opis sterownika. */
const struct EthernetDriverInfo* ethernetDriverGetInfo();



struct EthernetDriverStat{
  int received_packets;           /* Liczba otrzymanych pakietów. */
  int total_sent_packets;         /* Liczba wysłany pakietów (sukcesy i niepowodzenia). */
  int successfully_sent_packets;  /* Liczba wysłanych pakietów - powodzenie. */
  int failed_sent_packets;        /* Liczba wysłanych pakietów - niepowodzenie. */
};

/* Zwraca informacje statystyczne na temat sterownika ethernetowego. */
struct EthernetDriverStat ethernetDriverGetStatistics();


struct IpAddress{
  char address[16];
  char subnet[16];
};

/* Zapisuje informacje o adresie IP w buforze 'ip', który musi zostać podany
   przez jednostkę wywołującą. */
void ethernetDriverGetIp(struct IpAddress* ip);


struct Packet
{
  char data[1500]; /* Maksymalnie 1500 bajtów na pakiet. */
  int size;        /* Rzeczywista ilość danych w pakiecie. */
};

/* Zwraca wskaźnik do pakietu. Jednostka wywołująca musi zwolnić ten wskaźnik. */
struct Packet* ethernetDriverGetPacket();

#endif

