;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   Schemat podcze programowanego ukadu
;
;                 +----v----+
;           MCLR [| 1     40|] 
;                [| 2     39|] 
;                [| 3     38|] 
;                [| 4     37|] 
;                [| 5     36|] 
;                [| 6     35|] 
;      D1 <- RA5 [| 7     34|] 
;                [| 8     33|] 
;                [| 9     32|] VDD
;                [|10     31|] VSS
;            VDD [|11     30|] 
;            VSS [|12     29|] 
;(20 MHz) / OSC1 [|13     28|]
;         \ OSC2 [|14     27|]
;                [|15     26|] 
;                [|16     25|] 
;                [|17     24|]
;                [|18     23|] 
;                [|19     22|] 
;                [|20     21|] 
;                 +---------+
;                 PIC16F877A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
#include <p16F877a.inc>

;ustawienia bitw konfiguracyjnych (oscylator 20 MHz)
	__CONFIG _CP_OFF&_WDT_OFF&_BODEN_OFF&_PWRTE_OFF&_HS_OSC&_WRT_OFF&_LVP_OFF&_CPD_OFF

;;;;;;;;;;;;;;;;;;;;;
;definicje rejestrw
R0	EQU 0x20
R1	EQU 0x21
R2	EQU 0x22
R3	EQU 0x23
;;;;;;;;;;;;;;;;;;;;;
;kod programu
	ORG 0x000

	bsf	STATUS, 5		;ustaw 5. bit rejestru STATUS (przejd do banku 1.)
	movlw	0x06		;przelij warto 0x06 do rejestru W
	movwf	ADCON1		;zaaduj rejestr ADCON1 wartoci z W (linie cyfrowe)
	movlw	0x00		;przelij warto 0x00 do rejestru W
	movwf	TRISA		;zaaduj rejestr TRISA wartoci z W (port A wyjciowy)
	bcf	STATUS, 5		;wyzeruj 5. bit rejestru STATUS (przejd do banku 0)

	

;ptla nieskoczona
petla:
	;;;;;;;;;;;;;;;;;;;;;
	bsf 	PORTA, 5	;ustaw 5. bit portu A (zawie diod LED)
	;;;;;;;;;;;;;;;;;;;;;\
	movlw   0			; \
	movwf   R3			;  \
	movlw   0			;   \
	movwf   R2			;    \
	movlw   0xC3		;     >zaczekaj 0,5 sekundy
	movwf   R1			;    /
	movlw   0x50		;   /
	movwf   R0			;  /
	call 	Czekaj_10us	; /
	;;;;;;;;;;;;;;;;;;;;;/
	bcf 	PORTA, 5	;zeruj 5. bit portu A (zga diod LED)
	;;;;;;;;;;;;;;;;;;;;;\
	movlw   0			; \
	movwf   R3			;  \
	movlw   0			;   \
	movwf   R2			;    \
	movlw   0xC3		;     >zaczekaj 0,5 sekundy
	movwf   R1			;    /
	movlw   0x50		;   /
	movwf   R0			;  /
	call 	Czekaj_10us	; /
	;;;;;;;;;;;;;;;;;;;;;/
	goto petla

;Minimalny argument = 1 (10 us)
;Maksymalny argument = 0xFFFFFFFF (42 949 672 950 us = prawie 12 godzin)
Czekaj_10us:
;zmniejsz argument o 1 (8 cykli)
	movlw	1			;W = 1
	subwf	R0, 1		;odejmij od R0 warto z rejestru W
	btfss	STATUS, 0	;pomi nast. instrukcj, jeli nie byo poyczki
	subwf	R1, 1		;odejmij od R1 warto z rejestru W
	btfss	STATUS, 0	;pomi nast. instrukcj, jeli nie byo poyczki
	subwf	R2, 1		;odejmij od R2 warto z rejestru W
	btfss	STATUS, 0	;pomi nast. instrukcj, jeli nie byo poyczki
	subwf	R3, 1		;odejmij od R3 warto z rejestru W
;wypenienie 19 cykli
	movlw	d'252'		;zaaduj do W liczb 252
petelka_czekaj_10us_1:
		addlw	1						;dodaj do W liczb 1
		btfss	STATUS, 0				;pomi nast. instrukcj, jeli byo przeniesienie
		goto	petelka_czekaj_10us_1	;skocz do etykiety
	nop					;nic nie rb
	nop					;nic nie rb
	nop					;nic nie rb
;zmniejsz liczb o 1 (10 cykli)
petla_czekaj_10us:
	movlw	1			;W = 1
	subwf	R0, 1		;odejmij od R0 warto z rejestru W
	btfss	STATUS, 0	;pomi nast. instrukcj, jeli nie byo poyczki
	subwf	R1, 1		;odejmij od R0 warto z rejestru W
	btfss	STATUS, 0	;pomi nast. instrukcj, jeli nie byo poyczki
	subwf	R2, 1		;odejmij od R0 warto z rejestru W
	btfss	STATUS, 0	;pomi nast. instrukcj, jeli nie byo poyczki
	subwf	R3, 1		;odejmij od R0 warto z rejestru W
	btfss	STATUS, 0	;pomi nast. instrukcj, jeli nie byo poyczki
	goto	koniec_czekaj_10us

;wypenienie 38 cykli
	movlw	d'247'
petelka_czekaj_10us_2:
		addlw	1						;dodaj do W liczb 1
		btfss	STATUS, 0				;pomi nast. instrukcj, jeli byo przeniesienie
		goto	petelka_czekaj_10us_2	;skocz do etykiety
	nop					;nic nie rb
	nop					;nic nie rb

	goto	petla_czekaj_10us
;obuga podprogramu = 12 cykli
koniec_czekaj_10us:
	return				;powrt z podprogramu
	

	END		;koniec programu
