/**************************************************************
   Schemat podcze programowanego ukadu

                      +----v----+
                MCLR [| 1     40|] 
                     [| 2     39|] 
                     [| 3     38|] 
                     [| 4     37|] 
                     [| 5     36|] 
                     [| 6     35|] 
                     [| 7     34|] 
                     [| 8     33|] RB0/INT <- S1
                     [| 9     32|] VDD
                     [|10     31|] VSS
                 VDD [|11     30|] 
                 VSS [|12     29|] 
     (20 MHz) / OSC1 [|13     28|]
              \ OSC2 [|14     27|]
                     [|15     26|] 
                     [|16     25|] 
                     [|17     24|] 
                     [|18     23|] 
                     [|19     22|] 
           D1 <- RD1 [|20     21|]
                      +---------+
                      PIC16F877A

***************************************************************/

//definiujemy szybko oscylatora dla funkcji __delay_
#define _XTAL_FREQ 20000000
#include <htc.h>

//oscylator 20 MHz (FOSC_HS)
//watchdog wyczony (WDTE_OFF)
//wyczone LVP (Low-Voltage ICSP Programming) (LVP_OFF)
__CONFIG(FOSC_HS & WDTE_OFF & LVP_OFF);

unsigned char licznik;

void main()
{
	ADCON1 = 0x06;			//wyczenie linii analogowych 
                    		//(wszystkie linie cyfrowe)
	
	TRISDbits.TRISD1 = 0;	//linia RD1 wyjciowa

	//konfiguracja przerwania RB0/INT
	OPTION_REGbits.INTEDG = 0;	//reakcja na zbocze opadajce
	INTCONbits.INTE = 1;		//wcz przerwanie RB0/INT
	INTCONbits.GIE = 1;			//globalne wczenie przerwa

	licznik = 40;				//warto dla czasu 5 s
	for(;;)						//ptla nieskoczona
	{
		licznik--;
		if(licznik == 0) 
		{
			PORTDbits.RD1 = 0;	//wycz diod
			SLEEP();			//przejd w stan upienia
		}
		//mruganie diody
		PORTDbits.RD1 ^= 1;
		__delay_ms(125);
	}
}

static void interrupt
knowania_przerwania(void)
{
	if(INTCONbits.INTF) 
	{				
		licznik = 40;			//odwie licznik na czas 5 sekund
		INTCONbits.INTF = 0;	//wyczy flag przerwania
	}
}

