;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   Schemat podcze programowanego ukadu
;
;                 +----v----+
;           MCLR [| 1     40|] 
;                [| 2     39|] 
;                [| 3     38|] RB5 -> RS_LCD
;                [| 4     37|] RB4 -> EN_LCD
;                [| 5     36|] 
;                [| 6     35|] 
;                [| 7     34|] 
;                [| 8     33|] 
;                [| 9     32|] VDD
;                [|10     31|] VSS
;            VDD [|11     30|] 
;            VSS [|12     29|] 
;(20 MHz) / OSC1 [|13     28|]
;         \ OSC2 [|14     27|]
;                [|15     26|] 
;                [|16     25|] 
;                [|17     24|] RC5 -> DB4_LCD
;                [|18     23|] RC4 -> DB5_LCD
;                [|19     22|] RD3 -> DB6_LCD
;                [|20     21|] RD2 -> DB7_LCD
;                 +---------+
;                 PIC16F877A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
#include <p16F877a.inc>


;ustawienia bitw konfiguracyjnych (oscylator 20 MHz)
	__CONFIG _CP_OFF&_WDT_OFF&_BODEN_OFF&_PWRTE_OFF&_HS_OSC&_WRT_OFF&_LVP_OFF&_CPD_OFF

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;kod programu
	ORG 0x000
	goto main			;skocz do programu gwnego

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;dodanie kodu bibliotek

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Biblioteka podprogramw opniajcych ;
;dla taktowania 20 MHz                 ;
;podprogram Czekaj_1us                 ;
;podprogram Czekaj_10us                ;
;parametry przekazywane w 4. rejestrach;
;R3:R2:R1:R0                           ;
#include "czas.inc"                    ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Biblioteka obsugi alfanumerycznego wywietlacza LCD      ;
	cblock	0x20                                           ;
                        ;argumenty podprogramu WyswietlLCD ;
	napis:	0x10		;zmienna 16-bajtowa (cig znakw)  ;
	ile					;zmienna bajtowa (liczba znakw)   ;
	dane_do_wyslania	;argument podprogramu Wyslij_do_LCD;
	y, x				;argumenty podpr. UstawKursorLCD   ;
	endc                                                   ;
;definicje staych biblioteki lcd.inc                      ;
TRIS_EN_LCD		EQU TRISB                                  ;
PORT_EN_LCD		EQU PORTB                                  ;
EN_LCD			EQU 4                                      ;
;                                                          ;
TRIS_RS_LCD		EQU TRISB                                  ;
PORT_RS_LCD		EQU PORTB                                  ;
RS_LCD			EQU 5                                      ;
;                                                          ;
TRIS_DB4_LCD	EQU TRISC                                  ;
PORT_DB4_LCD	EQU PORTC                                  ;
DB4_LCD			EQU 5                                      ;
;                                                          ;
TRIS_DB5_LCD	EQU TRISC                                  ;
PORT_DB5_LCD	EQU PORTC                                  ;
DB5_LCD			EQU 4                                      ;
;                                                          ;
TRIS_DB6_LCD	EQU TRISD                                  ;
PORT_DB6_LCD	EQU PORTD                                  ;
DB6_LCD			EQU 3                                      ;
;                                                          ;
TRIS_DB7_LCD	EQU TRISD                                  ;
PORT_DB7_LCD	EQU PORTD                                  ;
DB7_LCD			EQU 2                                      ;
#include "lcd.inc"                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;cz gwna programu
main:
	bsf	STATUS, 5		;ustaw 5. bit rejestru STATUS (przejd do banku 1.)
	movlw	0x06		;przelij warto 0x06 do rejestru W
	movwf	ADCON1		;zaaduj rejestr ADCON1 wartoci z W (linie cyfrowe)
	bcf	STATUS, 5		;wyzeruj 5. bit rejestru STATUS (przejd do banku 0)

	call	WlaczLCD	;inicjalizacja wywietlacza LCD
	;ustaw kursor
	movlw	1			;W = 1
	movwf	y			;W -> y
	movlw	5			;W = 5
	movwf	x			;W -> x
	call	UstawKursorLCD
	;zaaduj napis do wywietlenia (adresowanie porednie)
	movlw	0x20		;zaaduj do W adres napisu
	movwf	FSR			;zaaduj adres do FSR
	movlw	'C'			;1. litera napisu
	movwf	INDF		;lduje pod adresem 0x20
	incf	FSR, 1		;inkrementacja adresu
	movlw	'z'			;2. litera napisu
	movwf	INDF		;lduje pod adresem 0x21
	incf	FSR, 1		;inkrementacja adresu
	movlw	'u'			;3. litera napisu
	movwf	INDF		;lduje pod adresem 0x22
	incf	FSR, 1		;inkrementacja adresu
	movlw	'w'			;4. litera napisu
	movwf	INDF		;lduje pod adresem 0x23
	incf	FSR, 1		;inkrementacja adresu
	movlw	'a'			;5. litera napisu
	movwf	INDF		;lduje pod adresem 0x24
	incf	FSR, 1		;inkrementacja adresu
	movlw	'j'			;6. litera napisu
	movwf	INDF		;lduje pod adresem 0x25
	incf	FSR, 1		;inkrementacja adresu
	movlw	'!'			;7. znak napisu
	movwf	INDF		;lduje pod adresem 0x26
	movlw	7			;zaaduj do W dugo napisu
	movwf	ile			;W -> ile
	call	WyswietlLCD	;wywietl napis

;ptla nieskoczona
petla:
	goto petla

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	END		;koniec programu
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
