package com.minecraftmastery.thorium;

import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import cpw.mods.fml.common.IWorldGenerator;

public class ThoriumWorldGenerator implements IWorldGenerator {

	@Override
	public void generate(Random random, int x, int z, World world,
			IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
		if (world.provider.dimensionId == 0) {
			addOreSpawn(Thorium.thoriumOreBlock, world, random, x*16, z*16, 16, 16, 
					4 + random.nextInt(3), 500, 50, 90);
		}
	}

    /**
     * Dodaje generator rudy do Minecrafta. Wystarczy zarejestrowac wszystkie generowane rudy w tej metodzie w klasie IWorldGeneration
     *
     * @param Blok do wygenerowania
     * @param Swiat, w ktrym ma sie generowac
     * @param Losowy obiekt, sluzacy zwrcaniu losowych pozycji ze swiata w celu wygenerowania bloku
     * @param int przekazujacy wsplrzedna X do metody Generation
     * @param int przekazujacy wsplrzedna Z do metody Generation
     * @param int przekazujacy maksymalne wartosci wsplrzednej X do generowania na osi X w chunkach
     * @param int przekazujacy maksymalne wartosci wsplrzednej Z do generowania na osi Z w chunkach
     * @param int okreslajacy maksymalny rozmiar zloza
     * @param int okreslajacy prawdopodobienstwo wygenerowania bloku na chunk
     * @param int okreslajacy minimalna wartosc wspolrzednej Y, przy ktrej blok moze sie generowac
     * @param int okreslajacy maksymalna wartosc wspolrzednej Y, przy ktrej blok moze sie generowac
     **/
    public void addOreSpawn(Block block, World world, Random random, int blockXPos, 
    		    int blockZPos, int maxX, int maxZ, int maxVeinSize, 
    		    int chancesToSpawn, int minY, int maxY){
          int maxPossY = minY + (maxY - 1);
          assert maxY > minY: "Maksymalne Y musi byc wieksze od minimalnego Y";
          assert maxX > 0 && maxX <= 16: "addOreSpawn: Maksymalne X musi byc wieksze niz 0, a mniejsze od 16";
          assert minY > 0: "addOreSpawn: Minimalne Y musi byc wieksze niz 0";
          assert maxY < 256 && maxY > 0: "addOreSpawn: Maksymalne Y musi byc mniejsze od 256, ale wieksze niz 0";
          assert maxZ > 0 && maxZ <= 16: "addOreSpawn: Maksymalne Z musi byc wieksze niz 0, ale mniejsze niz 16";
         
          int diffBtwnMinMaxY = maxY - minY;
          for(int x = 0; x < chancesToSpawn; x++)
          {
                 int posX = blockXPos + random.nextInt(maxX);
                 int posY = minY + random.nextInt(diffBtwnMinMaxY);
                 int posZ = blockZPos + random.nextInt(maxZ);
                 (new WorldGenMinable(block, maxVeinSize)).generate(world, random, posX, posY, posZ);
          }
    }
	
}
