# Telugu (te) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                          | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | -------------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987వ                                                    | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5వ                                                       | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987వ                                                    | 1986-12-28T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5వ                                                       | 0004-12-26T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1వ                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2వ                                                       | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | త్రై1                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | త్రై2                                                    | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1వ త్రైమాసికం                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2వ త్రైమాసికం                                            | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                        | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1వ                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2వ                                                       | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | త్రై1                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | త్రై2                                                    | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1వ త్రైమాసికం                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2వ త్రైమాసికం                                            | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2వ                                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7వ                                                       | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | ఫిబ్ర                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | జులై                                                     | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | ఫిబ్రవరి                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | జులై                                                     | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | ఫి                                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | జు                                                       | 2019-01-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2వ                                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7వ                                                       | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | ఫిబ్ర                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | జులై                                                     | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | ఫిబ్రవరి                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | జులై                                                     | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | ఫి                                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | జు                                                       | 2019-01-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1వ                                                       | 2018-12-30T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 49వ                                                      | 2019-12-01T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1వ                                                       | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48వ                                                      | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11వ                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28వ                                                      | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42వ                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365వ                                                     | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | సోమ                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | శుక్ర                                                    | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | సోమ                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | శుక్ర                                                    | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | సోమ                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | శుక్ర                                                    | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | సోమవారం                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | శుక్రవారం                                                | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | సో                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | శు                                                       | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | సోమ                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | శుక్ర                                                    | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1వ                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5వ                                                       | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | సోమ                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | శుక్ర                                                    | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | సోమవారం                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | శుక్రవారం                                                | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | సో                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | శు                                                       | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | సోమ                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | శుక్ర                                                    | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 2వ                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 6వ                                                       | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | సోమ                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | శుక్ర                                                    | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | సోమవారం                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | శుక్రవారం                                                | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | సో                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | శు                                                       | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | సోమ                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | శుక్ర                                                    | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 2వ                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 6వ                                                       | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | సోమ                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | శుక్ర                                                    | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | సోమవారం                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | శుక్రవారం                                                | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | సో                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | శు                                                       | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | సోమ                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | శుక్ర                                                    | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | పూర్వాహ్నం                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | అపరాహ్నం                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | అపరాహ్నం                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | పూర్వాహ్నం                                               | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | పూర్వాహ్నం                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | అపరాహ్నం                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | అపరాహ్నం                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | పూర్వాహ్నం                                               | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | పూర్వాహ్నం                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | అపరాహ్నం                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | అపరాహ్నం                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | పూర్వాహ్నం                                               | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | పూర్వాహ్నం                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | అపరాహ్నం                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | అపరాహ్నం                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | పూర్వాహ్నం                                               | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | పూర్వాహ్నం                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | అపరాహ్నం                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | అపరాహ్నం                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | పూర్వాహ్నం                                               | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | పూర్వాహ్నం                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | అపరాహ్నం                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | అపరాహ్నం                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | పూర్వాహ్నం                                               | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | పూర్వాహ్నం                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | అపరాహ్నం                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | అపరాహ్నం                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | పూర్వాహ్నం                                               | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | పూర్వాహ్నం                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | అపరాహ్నం                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | అపరాహ్నం                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | పూర్వాహ్నం                                               | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | పూర్వాహ్నం                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | అపరాహ్నం                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | అపరాహ్నం                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | పూర్వాహ్నం                                               | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | పూర్వాహ్నం                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | అపరాహ్నం                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | అపరాహ్నం                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | పూర్వాహ్నం                                               | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | ఉదయం                                                     | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | మధ్యాహ్నం                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | సాయంత్రం                                                 | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | రాత్రి                                                   | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | ఉదయం                                                     | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | మధ్యాహ్నం                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | సాయంత్రం                                                 | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | రాత్రి                                                   | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | ఉదయం                                                     | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | మధ్యాహ్నం                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | సాయంత్రం                                                 | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | రాత్రి                                                   | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | ఉదయం                                                     | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | మధ్యాహ్నం                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | సాయంత్రం                                                 | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | రాత్రి                                                   | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | ఉదయం                                                     | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | మధ్యాహ్నం                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | సాయంత్రం                                                 | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | రాత్రి                                                   | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11వ                                                      | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11వ                                                      | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11వ                                                      | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23వ                                                      | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11వ                                                      | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11వ                                                      | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11వ                                                      | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23వ                                                      | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1వ                                                       | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55వ                                                      | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1వ                                                       | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55వ                                                      | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 11-02-87                                                 | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29-05-53                                                 | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 11 ఫిబ్ర, 1987                                           | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 మే, 1453                                              | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 11 ఫిబ్రవరి, 1987                                        | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 మే, 1453                                              | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | 11, ఫిబ్రవరి 1987, బుధవారం                               | 1987-02-04T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29, మే 1453, ఆదివారం                                     | 1453-05-01T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13 అపరాహ్నం                                           | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59 అపరాహ్నం                                           | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14 అపరాహ్నం                                        | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 అపరాహ్నం                                        | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 అపరాహ్నం GMT+0                                  | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 అపరాహ్నం GMT+0                                  | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 అపరాహ్నం GMT+00:00                              | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 అపరాహ్నం GMT+00:00                              | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 11-02-87 12:13 అపరాహ్నం                                  | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29-05-53 11:59 అపరాహ్నం                                  | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 11 ఫిబ్ర, 1987 12:13:14 అపరాహ్నం                         | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 మే, 1453 11:59:59 అపరాహ్నం                            | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 11 ఫిబ్రవరి, 1987 12:13:14 అపరాహ్నం GMT+0కి              | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 మే, 1453 11:59:59 అపరాహ్నం GMT+0కి                    | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | 11, ఫిబ్రవరి 1987, బుధవారం 12:13:14 అపరాహ్నం GMT+00:00కి | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29, మే 1453, ఆదివారం 11:59:59 అపరాహ్నం GMT+00:00కి       | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result                 | `includeSeconds: true` | `addSuffix: true`         |
| ------------------------ | ---------------------- | ---------------------- | ------------------------- |
| 2006-01-01T00:00:00.000Z | సుమారు 6 సంవత్సరాలు    | సుమారు 6 సంవత్సరాలు    | సుమారు 6 సంవత్సరాలలో      |
| 2005-01-01T00:00:00.000Z | సుమారు 5 సంవత్సరాలు    | సుమారు 5 సంవత్సరాలు    | సుమారు 5 సంవత్సరాలలో      |
| 2004-01-01T00:00:00.000Z | సుమారు 4 సంవత్సరాలు    | సుమారు 4 సంవత్సరాలు    | సుమారు 4 సంవత్సరాలలో      |
| 2003-01-01T00:00:00.000Z | సుమారు 3 సంవత్సరాలు    | సుమారు 3 సంవత్సరాలు    | సుమారు 3 సంవత్సరాలలో      |
| 2002-01-01T00:00:00.000Z | సుమారు 2 సంవత్సరాలు    | సుమారు 2 సంవత్సరాలు    | సుమారు 2 సంవత్సరాలలో      |
| 2001-06-01T00:00:00.000Z | ఒక సంవత్సరం పైగా       | ఒక సంవత్సరం పైగా       | ఒక సంవత్సరంలో             |
| 2001-02-01T00:00:00.000Z | సుమారు ఒక సంవత్సరం     | సుమారు ఒక సంవత్సరం     | సుమారు ఒక సంవత్సరంలో      |
| 2001-01-01T00:00:00.000Z | సుమారు ఒక సంవత్సరం     | సుమారు ఒక సంవత్సరం     | సుమారు ఒక సంవత్సరంలో      |
| 2000-06-01T00:00:00.000Z | 5 నెలలు                | 5 నెలలు                | 5 నెలలలో                  |
| 2000-03-01T00:00:00.000Z | 2 నెలలు                | 2 నెలలు                | 2 నెలలలో                  |
| 2000-02-01T00:00:00.000Z | సుమారు ఒక నెల          | సుమారు ఒక నెల          | సుమారు ఒక నెలలో           |
| 2000-01-15T00:00:00.000Z | 14 రోజులు              | 14 రోజులు              | 14 రోజులలో                |
| 2000-01-02T00:00:00.000Z | ఒక రోజు                | ఒక రోజు                | ఒక రోజులో                 |
| 2000-01-01T06:00:00.000Z | సుమారు 6 గంటలు         | సుమారు 6 గంటలు         | సుమారు 6 గంటలలో           |
| 2000-01-01T01:00:00.000Z | సుమారు ఒక గంట          | సుమారు ఒక గంట          | సుమారు ఒక గంటలో           |
| 2000-01-01T00:45:00.000Z | సుమారు ఒక గంట          | సుమారు ఒక గంట          | సుమారు ఒక గంటలో           |
| 2000-01-01T00:30:00.000Z | 30 నిమిషాలు            | 30 నిమిషాలు            | 30 నిమిషాలలో              |
| 2000-01-01T00:15:00.000Z | 15 నిమిషాలు            | 15 నిమిషాలు            | 15 నిమిషాలలో              |
| 2000-01-01T00:01:00.000Z | ఒక నిమిషం              | ఒక నిమిషం              | ఒక నిమిషంలో               |
| 2000-01-01T00:00:25.000Z | ఒక నిమిషం కన్నా తక్కువ | అర నిమిషం              | ఒక నిమిషంలో               |
| 2000-01-01T00:00:15.000Z | ఒక నిమిషం కన్నా తక్కువ | 20 సెకన్ల కన్నా తక్కువ | ఒక నిమిషంలో               |
| 2000-01-01T00:00:05.000Z | ఒక నిమిషం కన్నా తక్కువ | 10 సెకన్ల కన్నా తక్కువ | ఒక నిమిషంలో               |
| 2000-01-01T00:00:00.000Z | ఒక నిమిషం కన్నా తక్కువ | 5 సెకన్ల కన్నా తక్కువ  | ఒక నిమిషం క్రితం          |
| 1999-12-31T23:59:55.000Z | ఒక నిమిషం కన్నా తక్కువ | 10 సెకన్ల కన్నా తక్కువ | ఒక నిమిషం క్రితం          |
| 1999-12-31T23:59:45.000Z | ఒక నిమిషం కన్నా తక్కువ | 20 సెకన్ల కన్నా తక్కువ | ఒక నిమిషం క్రితం          |
| 1999-12-31T23:59:35.000Z | ఒక నిమిషం కన్నా తక్కువ | అర నిమిషం              | ఒక నిమిషం క్రితం          |
| 1999-12-31T23:59:00.000Z | ఒక నిమిషం              | ఒక నిమిషం              | ఒక నిమిషం క్రితం          |
| 1999-12-31T23:45:00.000Z | 15 నిమిషాలు            | 15 నిమిషాలు            | 15 నిమిషాల క్రితం         |
| 1999-12-31T23:30:00.000Z | 30 నిమిషాలు            | 30 నిమిషాలు            | 30 నిమిషాల క్రితం         |
| 1999-12-31T23:15:00.000Z | సుమారు ఒక గంట          | సుమారు ఒక గంట          | సుమారు ఒక గంట క్రితం      |
| 1999-12-31T23:00:00.000Z | సుమారు ఒక గంట          | సుమారు ఒక గంట          | సుమారు ఒక గంట క్రితం      |
| 1999-12-31T18:00:00.000Z | సుమారు 6 గంటలు         | సుమారు 6 గంటలు         | సుమారు 6 గంటల క్రితం      |
| 1999-12-30T00:00:00.000Z | 2 రోజులు               | 2 రోజులు               | 2 రోజుల క్రితం            |
| 1999-12-15T00:00:00.000Z | 17 రోజులు              | 17 రోజులు              | 17 రోజుల క్రితం           |
| 1999-12-01T00:00:00.000Z | సుమారు ఒక నెల          | సుమారు ఒక నెల          | సుమారు ఒక నెల క్రితం      |
| 1999-11-01T00:00:00.000Z | 2 నెలలు                | 2 నెలలు                | 2 నెలల క్రితం             |
| 1999-06-01T00:00:00.000Z | 7 నెలలు                | 7 నెలలు                | 7 నెలల క్రితం             |
| 1999-01-01T00:00:00.000Z | సుమారు ఒక సంవత్సరం     | సుమారు ఒక సంవత్సరం     | సుమారు ఒక సంవత్సరం క్రితం |
| 1998-12-01T00:00:00.000Z | సుమారు ఒక సంవత్సరం     | సుమారు ఒక సంవత్సరం     | సుమారు ఒక సంవత్సరం క్రితం |
| 1998-06-01T00:00:00.000Z | ఒక సంవత్సరం పైగా       | ఒక సంవత్సరం పైగా       | ఒక సంవత్సరం క్రితం        |
| 1998-01-01T00:00:00.000Z | సుమారు 2 సంవత్సరాలు    | సుమారు 2 సంవత్సరాలు    | సుమారు 2 సంవత్సరాల క్రితం |
| 1997-01-01T00:00:00.000Z | సుమారు 3 సంవత్సరాలు    | సుమారు 3 సంవత్సరాలు    | సుమారు 3 సంవత్సరాల క్రితం |
| 1996-01-01T00:00:00.000Z | సుమారు 4 సంవత్సరాలు    | సుమారు 4 సంవత్సరాలు    | సుమారు 4 సంవత్సరాల క్రితం |
| 1995-01-01T00:00:00.000Z | సుమారు 5 సంవత్సరాలు    | సుమారు 5 సంవత్సరాలు    | సుమారు 5 సంవత్సరాల క్రితం |
| 1994-01-01T00:00:00.000Z | సుమారు 6 సంవత్సరాలు    | సుమారు 6 సంవత్సరాలు    | సుమారు 6 సంవత్సరాల క్రితం |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result       | `addSuffix: true`  | With forced unit (i.e. `hour`) |
| ------------------------ | ------------ | ------------------ | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 సంవత్సరాలు | 6 సంవత్సరాలలో      | 52608 గంటలు                    |
| 2005-01-01T00:00:00.000Z | 5 సంవత్సరాలు | 5 సంవత్సరాలలో      | 43848 గంటలు                    |
| 2004-01-01T00:00:00.000Z | 4 సంవత్సరాలు | 4 సంవత్సరాలలో      | 35064 గంటలు                    |
| 2003-01-01T00:00:00.000Z | 3 సంవత్సరాలు | 3 సంవత్సరాలలో      | 26304 గంటలు                    |
| 2002-01-01T00:00:00.000Z | 2 సంవత్సరాలు | 2 సంవత్సరాలలో      | 17544 గంటలు                    |
| 2001-06-01T00:00:00.000Z | ఒక సంవత్సరం  | ఒక సంవత్సరంలో      | 12408 గంటలు                    |
| 2001-02-01T00:00:00.000Z | ఒక సంవత్సరం  | ఒక సంవత్సరంలో      | 9528 గంటలు                     |
| 2001-01-01T00:00:00.000Z | ఒక సంవత్సరం  | ఒక సంవత్సరంలో      | 8784 గంటలు                     |
| 2000-06-01T00:00:00.000Z | 5 నెలలు      | 5 నెలలలో           | 3648 గంటలు                     |
| 2000-03-01T00:00:00.000Z | 2 నెలలు      | 2 నెలలలో           | 1440 గంటలు                     |
| 2000-02-01T00:00:00.000Z | ఒక నెల       | ఒక నెలలో           | 744 గంటలు                      |
| 2000-01-15T00:00:00.000Z | 14 రోజులు    | 14 రోజులలో         | 336 గంటలు                      |
| 2000-01-02T00:00:00.000Z | ఒక రోజు      | ఒక రోజులో          | 24 గంటలు                       |
| 2000-01-01T06:00:00.000Z | 6 గంటలు      | 6 గంటలలో           | 6 గంటలు                        |
| 2000-01-01T01:00:00.000Z | ఒక గంట       | ఒక గంటలో           | ఒక గంట                         |
| 2000-01-01T00:45:00.000Z | 45 నిమిషాలు  | 45 నిమిషాలలో       | ఒక గంట                         |
| 2000-01-01T00:30:00.000Z | 30 నిమిషాలు  | 30 నిమిషాలలో       | ఒక గంట                         |
| 2000-01-01T00:15:00.000Z | 15 నిమిషాలు  | 15 నిమిషాలలో       | 0 గంటలు                        |
| 2000-01-01T00:01:00.000Z | ఒక నిమిషం    | ఒక నిమిషంలో        | 0 గంటలు                        |
| 2000-01-01T00:00:25.000Z | 25 సెకన్ల    | 25 సెకన్లలో        | 0 గంటలు                        |
| 2000-01-01T00:00:15.000Z | 15 సెకన్ల    | 15 సెకన్లలో        | 0 గంటలు                        |
| 2000-01-01T00:00:05.000Z | 5 సెకన్ల     | 5 సెకన్లలో         | 0 గంటలు                        |
| 2000-01-01T00:00:00.000Z | 0 సెకన్ల     | 0 సెకన్ల క్రితం    | 0 గంటలు                        |
| 1999-12-31T23:59:55.000Z | 5 సెకన్ల     | 5 సెకన్ల క్రితం    | 0 గంటలు                        |
| 1999-12-31T23:59:45.000Z | 15 సెకన్ల    | 15 సెకన్ల క్రితం   | 0 గంటలు                        |
| 1999-12-31T23:59:35.000Z | 25 సెకన్ల    | 25 సెకన్ల క్రితం   | 0 గంటలు                        |
| 1999-12-31T23:59:00.000Z | ఒక నిమిషం    | ఒక నిమిషం క్రితం   | 0 గంటలు                        |
| 1999-12-31T23:45:00.000Z | 15 నిమిషాలు  | 15 నిమిషాల క్రితం  | 0 గంటలు                        |
| 1999-12-31T23:30:00.000Z | 30 నిమిషాలు  | 30 నిమిషాల క్రితం  | ఒక గంట                         |
| 1999-12-31T23:15:00.000Z | 45 నిమిషాలు  | 45 నిమిషాల క్రితం  | ఒక గంట                         |
| 1999-12-31T23:00:00.000Z | ఒక గంట       | ఒక గంట క్రితం      | ఒక గంట                         |
| 1999-12-31T18:00:00.000Z | 6 గంటలు      | 6 గంటల క్రితం      | 6 గంటలు                        |
| 1999-12-30T00:00:00.000Z | 2 రోజులు     | 2 రోజుల క్రితం     | 48 గంటలు                       |
| 1999-12-15T00:00:00.000Z | 17 రోజులు    | 17 రోజుల క్రితం    | 408 గంటలు                      |
| 1999-12-01T00:00:00.000Z | ఒక నెల       | ఒక నెల క్రితం      | 744 గంటలు                      |
| 1999-11-01T00:00:00.000Z | 2 నెలలు      | 2 నెలల క్రితం      | 1464 గంటలు                     |
| 1999-06-01T00:00:00.000Z | 7 నెలలు      | 7 నెలల క్రితం      | 5136 గంటలు                     |
| 1999-01-01T00:00:00.000Z | ఒక సంవత్సరం  | ఒక సంవత్సరం క్రితం | 8760 గంటలు                     |
| 1998-12-01T00:00:00.000Z | ఒక సంవత్సరం  | ఒక సంవత్సరం క్రితం | 9504 గంటలు                     |
| 1998-06-01T00:00:00.000Z | 2 సంవత్సరాలు | 2 సంవత్సరాల క్రితం | 13896 గంటలు                    |
| 1998-01-01T00:00:00.000Z | 2 సంవత్సరాలు | 2 సంవత్సరాల క్రితం | 17520 గంటలు                    |
| 1997-01-01T00:00:00.000Z | 3 సంవత్సరాలు | 3 సంవత్సరాల క్రితం | 26280 గంటలు                    |
| 1996-01-01T00:00:00.000Z | 4 సంవత్సరాలు | 4 సంవత్సరాల క్రితం | 35064 గంటలు                    |
| 1995-01-01T00:00:00.000Z | 5 సంవత్సరాలు | 5 సంవత్సరాల క్రితం | 43824 గంటలు                    |
| 1994-01-01T00:00:00.000Z | 6 సంవత్సరాలు | 6 సంవత్సరాల క్రితం | 52584 గంటలు                    |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                          |
| ------------------------ | ------------------------------- |
| 2000-01-10T00:00:00.000Z | 10-01-00                        |
| 2000-01-05T00:00:00.000Z | తదుపరి బుధవారం 12:00 పూర్వాహ్నం |
| 2000-01-02T00:00:00.000Z | రేపు 12:00 పూర్వాహ్నం           |
| 2000-01-01T00:00:00.000Z | ఈ రోజు 12:00 పూర్వాహ్నం         |
| 1999-12-31T00:00:00.000Z | నిన్న 12:00 పూర్వాహ్నం          |
| 1999-12-27T00:00:00.000Z | గత సోమవారం 12:00 పూర్వాహ్నం     |
| 1999-12-21T00:00:00.000Z | 21-12-99                        |
