/*
 *
 *   Copyright (c) 2001, Carlos E. Vidales. All rights reserved.
 *
 *   This sample program was written and put in the public domain 
 *    by Carlos E. Vidales.  The program is provided "as is" 
 *    without warranty of any kind, either expressed or implied.
 *   If you choose to use the program within your own products
 *    you do so at your own risk, and assume the responsibility
 *    for servicing, repairing or correcting the program should
 *    it prove defective in any manner.
 *   You may copy and distribute the program's source code in any 
 *    medium, provided that you also include in each copy an
 *    appropriate copyright notice and disclaimer of warranty.
 *   You may also modify this program and distribute copies of
 *    it provided that you include prominent notices stating 
 *    that you changed the file(s) and the date of any change,
 *    and that you do not charge any royalties or licenses for 
 *    its use.
 * 
 *
 *   2015 This file has been changed by Tomasz Francuz
 *
 *
 *   File Name:  calibrate.h
 *
 *
 *   Definition of constants and structures, and declaration of functions 
 *    in Calibrate.c
 *
 */

#ifndef _CALIBRATE_H_

#define _CALIBRATE_H_

/****************************************************/
/*                                                  */
/* Included files                                   */
/*                                                  */
/****************************************************/

#include <stdint.h>
#include <stdbool.h>

/****************************************************/
/*                                                  */
/* Definitions                                      */
/*                                                  */
/****************************************************/

#ifndef		_CALIBRATE_C_
	#define		EXTERN         extern
#else
	#define		EXTERN
#endif

#define			CAL_INT				int32_t

/****************************************************/
/*                                                  */
/* Structures                                       */
/*                                                  */
/****************************************************/

//Zwr pozycj XY punktu
typedef struct
{
	int16_t X;       //Pozycja X
	int16_t Y;       //Pozycja Y
} TP_Position;

typedef struct Matrix {
							/* This arrangement of values facilitates 
							 *  calculations within getDisplayPoint() 
							 */
                        CAL_INT  An,     /* A = An/Divider */
                                 Bn,     /* B = Bn/Divider */
                                 Cn,     /* C = Cn/Divider */
                                 Dn,     /* D = Dn/Divider */
                                 En,     /* E = En/Divider */
                                 Fn,     /* F = Fn/Divider */
                                 Divider ;
                     } TP_MATRIX ;


EXTERN TP_MATRIX  TP_matrix ;   //Wspczynniki macierzy kalibracyjnej

/****************************************************/
/*                                                  */
/* Function declarations                            */
/*                                                  */
/****************************************************/


EXTERN _Bool setCalibrationMatrix( TP_Position * display,
                                 TP_Position * screen,
                                 TP_MATRIX * matrix) ;


EXTERN _Bool getDisplayPoint( TP_Position * display,
                            TP_Position * screen,
                            TP_MATRIX * matrix ) ;


#endif  /* _CALIBRATE_H_ */
