/*
 * Przebiegi.c
 *
 * Created: 2017-01-22 21:44:53
 * Author : tmf
 */ 

#include <avr/io.h>
#include <string.h>
#include <avr/interrupt.h>
#include <util/delay.h>
#include <util/atomic.h>
#include <stdbool.h>
#include <avr/pgmspace.h>
#include <stdlib.h>
#include <stdio.h>

#include "Clk/Clk.h"
#include "usart.h"
#include "bufusart.h"

//Makro umieszczajce zadany acuch w przestrzeni adresowej __flash
#define PGM_STR(X) ((const __flash char[]) { X })

void USART_init()
{
	USART_bufs_init();
	PORTC_OUTSET=PIN3_bm;
	PORTC_DIRSET=PIN3_bm;                          //Pin TxD musi by wyjciem
	USARTC0.CTRLA=USART_RXCINTLVL_LO_gc;           //Odblokuj przerwania odbiornika i nadajnika
	PMIC_CTRL|=PMIC_LOLVLEN_bm;                    //Odblokuj przerwanie niskiego poziomu
	USARTC0.CTRLB=USART_TXEN_bm | USART_RXEN_bm;   //Wcz nadajnik USART
	USARTC0.CTRLC=USART_CHSIZE_8BIT_gc;            //Ramka 8 bitw, bez parzystoci, 1 bit stopu
	usart_set_baudrate(&USARTC0, 9600, F_CPU);     //Szybko transmisji
}

void HMI_WaitForTxAndResponse()
{
	while(cb_ElementsNo(&recBuf) < 4);      //Zaczekaj na odpowied z moduu - otrzymanie 4 bajtw
}

uint8_t HMI_GetResponse()
{
	uint8_t res=-1;  //Brak poprawnej odpowiedzi
	
	if(cb_ElementsNo(&recBuf) >= 4)
	{
		uint8_t tmpres=cb_Read(&recBuf);
		uint8_t ff=cb_Read(&recBuf) & cb_Read(&recBuf) & cb_Read(&recBuf);
		if(ff==0xFF) res=tmpres;  //Jeli format odpowiedzi jest poprawny to j zwr
	}
	return res;  
}

uint8_t HMI_GetNumber(uint32_t *liczba)
{
	uint8_t res=-1;  //Brak poprawnej odpowiedzi
	
	if(cb_ElementsNo(&recBuf) >= 4)
	{
		res=cb_Read(&recBuf);   //Pobierz typ danych
		if(res == 0x71)         //Komunikat zawiera liczb
		{
			while(cb_ElementsNo(&recBuf) < 7);  //Komunikat musi zawiera kolejnych 7 bajtw
			*liczba=cb_Read(&recBuf) + (cb_Read(&recBuf) << 8) + ((uint32_t)cb_Read(&recBuf) << 8) + ((uint32_t)cb_Read(&recBuf) << 8);
		}
		uint8_t ff=cb_Read(&recBuf) & cb_Read(&recBuf) & cb_Read(&recBuf);
		if(ff != 0xFF) res=-1;  //Jeli format odpowiedzi jest poprawny to j zwr
	}
	return res;	
}

uint8_t HMI_GetString(char *str)
{
	uint8_t res=-1;  //Brak poprawnej odpowiedzi
	
	if(cb_ElementsNo(&recBuf) >= 4)
	{
		res=cb_Read(&recBuf);  //Pobierz typ danych
		if(res == 0x70)        //Komunikat zawiera acuch
		{
			uint16_t indeks=0;
			uint8_t znak, sufiks=0;
			do{
				while(cb_IsEmpty(&recBuf));  //Sprawd czy jest kolejny znak, jeli nie to zaczekaj
				znak=cb_Read(&recBuf);
				if(znak != 0xFF) 
				{
					str[indeks++]=znak;
					sufiks=0;
				} else sufiks++;
			} while(sufiks<3);
			str[indeks]=0;   //Utwrz poprawny acuch jzyka C
			res=0x01;
		} else
		{
			uint8_t ff=cb_Read(&recBuf) & cb_Read(&recBuf) & cb_Read(&recBuf);
			if(ff != 0xFF) res=-1;  //Jeli format odpowiedzi nie jest poprawny to zwr -1
		}
	}
	return res;
}

volatile static uint8_t resp;
volatile static uint32_t wynik;
char polecenie[40];

int main(void)
{
	SelectPLL(OSC_PLLSRC_RC2M_gc, 16);   //PLL 16x - na wyjciu 32 MHz
	CPU_CCP=CCP_IOREG_gc;
	CLK.CTRL=CLK_SCLKSEL_PLL_gc;         //Wybierz wyjcie PLL, czyli zegar 32 MHz
	
	USART_init();
	sei();
	
	srand(0);
	uint8_t ch0=50, ch1=75;
	
	USART_send_buf(PSTR("bkcmd=3\xff\xff\xff"));   //Wcz potwierdzenia wykonania przesanych polece
	HMI_WaitForTxAndResponse();
	resp=HMI_GetResponse();
	
	while(1)
	{
		sprintf(polecenie, "add 1,0,%u\xff\xff\xff", ch0);
		USART_send_buf(polecenie);
		sprintf(polecenie, "add 1,1,%u\xff\xff\xff", ch1);
		USART_send_buf(polecenie);

		if(rand() & 1) ch0++; else ch0--;
		if(rand() & 1) ch1++; else ch1--;
	}
}

