/*
 * ssd2119_DMA.c
 *
 * Created: 2014-11-09 16:11:46
 *  Author: tmf
 */ 

#include "sam.h"
#include <stdbool.h>
#include <stdlib.h>
#include <stdio.h>
#include "Clk/SetClk.h"
#include "Delay/delay.h"
#include "SPI/spi.h"
#include "ssd2119.h"
#include "GFXDrv.h"
#include "ADS7843/ADS7843.h"
#include "ADS7843/calibrate.h"
#include "Fonts/Fonts.h"

void SPI_init()
{
	//Konfiguracja SPI
	REG_PM_APBCMASK|=PM_APBCMASK_SERCOM1;  //Wcz zegar dla SERCOM1
	GCLK->CLKCTRL.reg = GCLK_CLKCTRL_ID(GCLK_CLKCTRL_ID_SERCOM1_CORE_Val) | //Generic Clock 0
										GCLK_CLKCTRL_GEN_GCLK0 |                            // jest rdem zegara
										GCLK_CLKCTRL_CLKEN;
		
	while(GCLK->STATUS.reg & GCLK_STATUS_SYNCBUSY); //Zaczekaj na zynchronizacj
	
	LCD_USART.CTRLA.bit.ENABLE=0;      //Wycz SERCOM1
	while(LCD_USART.SYNCBUSY.bit.ENABLE);
	LCD_USART.CTRLA.bit.SWRST=1;      //Zresetuj SERCOM1
	while(LCD_USART.CTRLA.bit.SWRST || LCD_USART.SYNCBUSY.bit.SWRST);
	
	SPI_SPICLKMAX();  //Zegar SPI max - 12 MHz
	LCD_USART.CTRLB.reg=SERCOM_SPI_CTRLB_RXEN; //Odblokuj odbiornik SPI, ramka 8 bitowa, programowa kontrola SS
	while(LCD_USART.SYNCBUSY.reg & SERCOM_SPI_SYNCBUSY_MASK);  //Zaczekaj na synchreonizacj zapisu rejestrw
	
	LCD_PORT.WRCONFIG.reg=PORT_WRCONFIG_HWSEL | PORT_WRCONFIG_WRPINCFG | PORT_WRCONFIG_WRPMUX | PORT_WRCONFIG_PMUX(2) | PORT_WRCONFIG_PMUXEN | 0b1101; //Wybierz funkcj SERCOM1 dla PA16-19
	
	LCD_USART.CTRLA.reg=SERCOM_SPI_CTRLA_ENABLE | SERCOM_SPI_CTRLA_MODE_SPI_MASTER | SERCOM_SPI_CTRLA_DOPO(1) | SERCOM_SPI_CTRLA_RUNSTDBY; //Tryb master SPI, Mode 0, MSB, PAD0 - MISO
	while(LCD_USART.SYNCBUSY.reg & SERCOM_SPI_SYNCBUSY_MASK);  //Zaczekaj na synchreonizacj zapisu rejestrw
}

void LCD_Interface_Init()
{
	ssd2119_CS(false);  //Sygna CS nieaktywny
	LCD_PORT.DIRSET.reg=LCD_CS | LCD_RS | LCD_RESET;	//Piny CS, RS i RESET jako wyjcia
	SPI_init();   //Zainicjuj uywany SPI (SERCOM1)
}

void TouchPanel_Calibrate()
{
	TP_Position perfectDisplaySample[3] = {  //Punkty kalibracyjne na TP - uywamy tylko trzech
		{50, 40},
		{100, 200},
		{300, 120}
	};
	
	TP_Position ScreenSample[3];  //Pobrane prbki z panela

	void GetCalPoint(uint8_t sample)
	{
		TP_Position pos;
		LCD_Circle(perfectDisplaySample[sample].X, perfectDisplaySample[sample].Y, 5, true, 0x00ff00);
		
		while((LCD_PORT.IN.reg & TP_INT) != 0);  //Poczekaj na dotyk
		_delay_ms(20);    //Zaczekaj na koniec drga
		
		TouchPanel_GetPositionXY(&pos); 	//Pobierz miejsce dotknicia

		while((LCD_PORT.IN.reg & TP_INT) == 0);   //Poczekaj na zwolnienie panela

		_delay_ms(100);	//Odczekaj chwil, aby wyeliminowa ew. drgania
		
		LCD_Circle(perfectDisplaySample[sample].X, perfectDisplaySample[sample].Y, 5, true, 0x000000);
		
		ScreenSample[sample].X=pos.X>>2; ScreenSample[sample].Y=pos.Y>>2;
	}
	
	for(uint8_t i=0; i<sizeof(perfectDisplaySample)/sizeof(perfectDisplaySample[0]); i++) GetCalPoint(i);	//Pobierz kolejne prbki z ADC
	
	setCalibrationMatrix(&perfectDisplaySample[0], &ScreenSample[0], &TP_matrix);  //Policz macierz
}

int main(void)
{
	Set48MHzClk();
	delay_init();
	LCD_Interface_Init();
	LCD_Init262();
	Touch_Panel_Init();                  //Inicjalizacja obsugi TP

	LCD_Rect(0, 0, LCD_GetMaxX()-1, LCD_GetMaxY()-1, 0x000000);   //Wyczy ekran
	
	Touch_Panel_Init();                  //Inicjalizacja obsugi TP

	TP_Position XY, dis_point, scr;
	
	TouchPanel_Calibrate();   //Skalibruj panel dotykowy
	
	
	while(1)
	{
		TouchPanel_GetPositionXY(&XY);
		dis_point.X=XY.X>>2; dis_point.Y=XY.Y>>2;   //Potrzebujemy tylko 10-bitw z ADC, wicej bitw, to konieczno uycia szerszego typu do oblicze
		getDisplayPoint(&scr, &dis_point, &TP_matrix);
		
		if((LCD_PORT.IN.reg & TP_INT) == 0)
		{
			LCD_SetPixel(scr.X, scr.Y, 0xff0000);
		}
	}
}

