/* Kod, ktory odczytuje temperature ciala za pomoca czujnika MLX90614
 * podlaczonego do magistrali I2C w Arduino Uno.
 * To jest kod dla Arduino Uno (ktore jest urzadzeniem peryferyjnym lub slave).
 * Dane o temperaturze beda wysylane magistrala I2C do plytki Blue Pill.
 * Autor: Miguel Garcia-Ruiz
 * 3 luty 2021
 * Wersja 1.0
 * 
* PROGRAM JEST OFEROWANY “TAK JAK JEST”, BEZ JAKICHKOLWIEK GWARANCJI WYRAZONYCH
 * WPROST LUB DOROZUMIANYCH, W TYM BEZ GWARANCJI WARTOSCI HANDLOWEJ I PRZYDATNOSCI
 * DO OKRESLONEGO CELU ORAZ BEZ GWARANCJI NIENARUSZENIA PRAW AUTORSKICH.
 * AUTRZY LUB POSIADACZE PRAW AUTORSKICH NIE PONOSZA ZADNEJ
 * ODPOWIEDZIALNOSCI ZA JAKIEKOLWIEK ROSZCZENIA, SZKODY LUB INNE PROBLEMY
 * WYNIKAJACE Z NARUSZENIA KONTRAKTU, KODEKSU CYWILNEGO CZY INNYCH PRAW,
 * A MAJACE ZWIAZEK Z PROGRAMEM LUB JEGO UZYCIEM.
 */
#include <Wire.h> //biblioteka obslugujaca magistrale I2C
#include <Adafruit_MLX90614.h> //biblioteka czujnika na podczerwien
Adafruit_MLX90614 mlx = Adafruit_MLX90614(); //inicjalizacja czujnika
#define ADRESSLAVE 0x8  //  adres Arduino jako urzadzenia slave

float TempwC = 0.0; //zmienna przechowujaca temperature w stopniach Celsjusza

void setup() {  
  Wire.begin(ADRESSLAVE); //zainicjowanie magistrali I2C
  Wire.onRequest(zadanieOdczytu); //przerwania obslugujace zadania, ktore przychodza z kontrolera (urzadzenia master)
}

void loop() {
  TempwC = mlx.readObjectTempC();// ciagly odczyt danych o temperaturze z czujnika
  delay(100);
}

void zadanieOdczytu() { //funkcja wykonywana za kazdym razem gdy kontroler (master) zazada danych od urzadzenia peryferyjnego (slave)
 //Ponizszy fragment bazuje na: https://medium.com/@sandhan.sarma/sending-floats-over-the-i2c-bus-between-two-arduinos-part-2-486db6dc479f
 //Ponizej zadeklarowalismy wlasna strukture danych (unie), ktora nazwalismy floatNaBajty.
 //Poza nazwa unii zadeklarowalismy takze nazwe jej zmiennej (konwerter). 
 //Unia danych floatNaBajty ma dwie zmienne: jedna to tablica znakow char o dlugosci 4 (bufor), a druga to float.
 //Zarowno odczytTemp, jak i bufor zajmuja to samo miejsce w pamieci - 4 elementy bufora wskazuja na te same 4 bajty zmiennej float o nazwie odczytTemp:
  union floatNaBajty {
    char bufor[4];
    float odczytTemp;
  } konwerter;
 //dodajemy trzy stopnie, zeby skompensowac temperature otoczenia:
  konwerter.odczytTemp = TempwC+3;
  Wire.write(konwerter.bufor, 4); //wysyla temperature magistrala I2C jako bajty
}
