{***************************************************************************}
{                       Modul WYKRESY                                       }
{                   Turbo Pascal  wersja 7.0                                }
{             autor Bernard Baron, Adam Gawlowski                           }
{***************************************************************************}

 UNIT WYKRESY;

 INTERFACE
   USES  CRT,GRAPH,TFLOAT;

   CONST SCIEZKA_BGI='C:\BP\BGI';

   TYPE  MAX2 = 0..1024;
         WEKI = ARRAY[MAX2]OF FLOAT;
         IWEKI= ARRAY[1..4]OF INTEGER;

   VAR   DRIVER,MODE :INTEGER;

   PROCEDURE WYKRESXY(VAR WX,WY:WEKI; { Wektory wezlow }
                          N:INTEGER;     { Ilosc wezlow   }
                          TYTULRYS1,TYTULRYS2,NAZWAX,NAZWAY:STRING);
{    Wykreslanie funkcji f(x) podanej w N punktach (WX[i],WY[i]);           }
{ 0<=i<=N; N<=MAX2.                                                         }
{ Pod wykresem znajduja sie linie tekstu zawartego w TYTULRYS1 i TYTULRYS2. }
{ System musi byc w trybie graficznym.                                      }


   PROCEDURE WYKRESXYG(VAR WX,WY:WEKI; { Wektory wezlow }
                           N:INTEGER;     { Ilosc wezlow   }
                           TYTULRYS1,TYTULRYS2,NAZWAX,NAZWAY:STRING);
{    Wykreslanie funkcji f(x) podanej w N punktach (WX[i],WY[i]);           }
{ 0<=i<=N; N<=MAX2.                                                         }
{ Pod wykresem znajduja sie linie tekstu zawartego w TYTULRYS1 i TYTULRYS2. }
{    Przed wykresleniem funkcji inicjowany jest tryb graficzny wysokiej     }
{ rozdzielczosci. Po wykresleniu system oczekuje na nacisniecie klawisza,   }
{ a nastepnie przywracany jest tryb graficzny.                              }



IMPLEMENTATION

     PROCEDURE INICJACJA_TRYBU_WYSOKIEJ_ROZDZIELCZOSCI;
       VAR GR:INTEGER;
       BEGIN
         DRIVER:=DETECT;
         INITGRAPH(DRIVER,MODE,SCIEZKA_BGI);
         GR:=GRAPHRESULT;
         IF GR<>GROK THEN
         BEGIN
           CLRSCR;
           WRITELN(GraphErrorMSG(GR));
	   WRITELN('Byc moze niewlasciwa sciezka dostepu do sterownikow graficznych');
           WRITELN('w module WYKRESY - stala "SCIEZKA_BGI".');
           WRITELN('Biezaca sciezka: ',SCIEZKA_BGI);
           WRITELN;
           HALT
         END

       END; { INICJACJA_TRYBU_WYSOKIEJ_ROZDZIELCZOSCI }

     PROCEDURE PAUSE;
     VAR KEY:CHAR;
     BEGIN
       KEY:=READKEY
     END; { PAUSE }

     FUNCTION WYK(X:FLOAT):INTEGER;
     BEGIN
       IF X<>0
         THEN WYK:=TRUNC(LN(ABS(X))/LN(10))
         ELSE WYK:=0
     END; { WYK }

     FUNCTION POT10(X:INTEGER):FLOAT;
             { POT10=10^X }
     BEGIN
       POT10:=EXP(X*LN(10))
     END; { POT10 }

     PROCEDURE ZAOKRAGL(VAR X:FLOAT; DX:FLOAT);
             { Zaokraglanie zera maszynowego }
     BEGIN
       IF ABS(X/DX)<1E-5 THEN
         X:=0
     END; { ZAOKRAGL }

     FUNCTION Z(X:FLOAT; W,K:INTEGER):FLOAT;
             { Zaokraglenie do K+1 liczb znaczacych }
     BEGIN
       Z:=POT10(W-K)*ROUND(POT10(-W+K)*X)
     END; { Z }

     FUNCTION MAX(X1,X2:FLOAT):FLOAT;
     BEGIN
       IF X1>X2
         THEN MAX:=X1
         ELSE MAX:=X2
     END; { MAX }

     FUNCTION MIN(X1,X2:FLOAT):FLOAT;
     BEGIN
       IF X1<X2
         THEN MIN:=X1
         ELSE MIN:=X2
     END; { MIN }

     FUNCTION T(X:FLOAT; W:INTEGER):STRING;
             { Formatowanie liczb }
     VAR T1:STRING;
     BEGIN
       IF (W<3) AND (W>-1)
         THEN STR(X:5:2-W,T1)
         ELSE STR(X*POT10(-W):5:2,T1);
       T:=T1
     END; { T }

     PROCEDURE SZUKAJ_EKSTREMUM(VAR MIN,MAX :FLOAT;
                                VAR W       :WEKI;
                                    N       :INTEGER);
     VAR I:INTEGER;
     BEGIN
       FOR I:=0 TO N DO
         IF MAX<W[I]
           THEN MAX:=W[I]
           ELSE IF MIN>W[I] THEN MIN:=W[I]
     END; { SZUKAJ_EKSTREMUM }

     PROCEDURE SKALA(    SY    :FLOAT;     { Przedzial zmiennosci funkcji    }
                     VAR KD    :INTEGER;   { Ilosc dzialek na osi            }
                     VAR SM,SX :FLOAT;     { Maksymalny przedzial zmiennosci }
                                           { funkcji i wielkosc dzialki      }
                     VAR WYK   :INTEGER);  { Wykladnik SM                    }
     VAR K1:BYTE;

         PROCEDURE POSZ;
         { Poszukiwanie najblizsej liczby SM'>SM podzielnej przez KD }
         BEGIN
           SM:=INT(SY+0.001);
           WHILE (FRAC(SM/4)<>0) AND (FRAC(SM/5)<>0) DO
             SM:=SM+1;
           IF FRAC(SM/4)=0
             THEN KD:=4
             ELSE KD:=5
         END; { POSZ }

     BEGIN
       IF SY>100
         THEN BEGIN
                K1:=0;
                REPEAT
                  SY:=SY/10; INC(K1)
                UNTIL SY<100;
                POSZ;
                SM:=SM*POT10(K1);
                SX:=SM/KD;
                WYK:=K1+1
              END
         ELSE IF SY<10
                THEN BEGIN
                       K1:=0;
                       REPEAT
                         SY:=SY*10; INC(K1)
                       UNTIL SY>=10;
                       POSZ;
                       SM:=SM*POT10(-K1);
                       SX:=SM/KD;
                       WYK:=-K1+1
                     END
                ELSE BEGIN
                       POSZ;
                       SX:=SM/KD;
                       WYK:=1
                     END
     END { SKALA };

     PROCEDURE SKALOWANIE_X(VAR MINX,MAXX,
                                SXD,SXG,
                                MINXP,MAXXP,
                                PSX                  :FLOAT;
                                DX,SX,
                                ZD,ZD1               :FLOAT;
                            VAR KDX,KGX,
                                X1,X11,X2,X22,X3,X33 :INTEGER;
                                LDX,
                                WYKX                 :INTEGER);
     VAR K:BYTE;
         SXD1,SXG1:FLOAT;
     BEGIN
       X22:=GETMAXX-20; X2:=X22-70;
       IF (MAXX>0) AND (MINX<0) THEN
       BEGIN
         KGX:=0; SXG:=0;
         WHILE SXG<(MAXX-ZD1*DX) DO
         BEGIN
           INC(KGX); SXG:=SX*KGX
         END;
         KDX:=0; SXD:=0;
         WHILE SXD>(MINX+ZD1*DX) DO
         BEGIN
           INC(KDX); SXD:=-SX*KDX
         END;
         IF KDX<>0
           THEN BEGIN
                  X33:=10; X3:=30
                END
           ELSE BEGIN
                  X33:=60; X3:=60
                END;
         K:=0;
         REPEAT
           SXD1:=Z(SXD,WYKX,K); SXG1:=Z(SXG,WYKX,K);
           INC(K)
         UNTIL ((SXD1<>SXG1) AND ((SXG1-SXD1)>ZD*DX) AND (ABS(SXD1-MINX)<ZD1*DX) AND (ABS(SXG1-MAXX)<ZD1*DX)) OR (K>5);
         SXD:=SXD1; SXG:=SXG1;
         MAXXP:=MAX(SXG,MAXX);
         MINXP:=MIN(SXD,MINX);
         X11:=ROUND(X3-MINXP*(X2-X3)/(MAXXP-MINXP));
         PSX:=0
       END;
       IF (MAXX>0) AND (MINX>=0) THEN
       BEGIN
         X33:=60; X3:=60;
         X11:=X33;
         KDX:=0; KGX:=LDX;
         K:=0;
         REPEAT
           SXD:=Z(MINX,WYKX,K); SXG:=Z(KGX*SX+SXD,WYKX,K);
           INC(K)
         UNTIL ((SXD<>SXG) AND ((SXG-SXD)>ZD*DX) AND (ABS(SXD-MINX)<ZD1*DX/2) AND (ABS(SXG-MAXX)<ZD1*DX)) OR (K>5);
         PSX:=SXD;
         MINXP:=MIN(SXD,MINX); MAXXP:=MAX(SXG,MAXX)
       END;
       IF (MAXX<=0) AND (MINX<0) THEN
       BEGIN
         X33:=10; X3:=30;
         X11:=X2;
         KDX:=LDX;  KGX:=0;
         K:=0;
         REPEAT
           SXG:=Z(MAXX,WYKX,K); SXD:=Z(-KDX*SX+SXG,WYKX,K);
           INC(K)
         UNTIL ((SXD<>SXG) AND ((SXG-SXD)>ZD*DX) AND (ABS(SXG-MAXX)<ZD1*DX/2) AND (ABS(SXD-MINX)<ZD1*DX)) OR (K>5);
         PSX:=SXG;
         MINXP:=MIN(SXD,MINX); MAXXP:=MAX(SXG,MAXX)
       END
     END; { SKALOWANIE_X }

     PROCEDURE SKALOWANIE_Y(VAR MINY,MAXY,
                                SYD,SYG,
                                MINYP,MAXYP,
                                PSY               :FLOAT;
                                DY,SY,
                                ZD,ZD1            :FLOAT;
                            VAR KDY,KGY,
                                Y1,Y11,Y22,Y3,Y33 :INTEGER;
                                LDY,
                                WYKY              :INTEGER);
     VAR SYD1,SYG1 :FLOAT;
         K         :INTEGER;
     BEGIN
       IF (MAXY>0) AND (MINY<0) THEN
       BEGIN
         KGY:=0; SYG:=0;
         WHILE SYG<(MAXY-DY/10) DO
         BEGIN
           INC(KGY); SYG:=SY*KGY
         END;
         KDY:=0;
         SYD:=0;
         WHILE SYD>(MINY+DY/10) DO
         BEGIN
           INC(KDY); SYD:=-SY*KDY
         END;
         IF KDY=0 THEN
         BEGIN
           Y33:=Y33-10; Y3:=Y33
         END;
         K:=0;
         REPEAT
           SYD1:=Z(SYD,WYKY,K); SYG1:=Z(SYG,WYKY,K);
           INC(K)
         UNTIL ((SYD1<>SYG1) AND ((SYG1-SYD1)>ZD*DY) AND (ABS(SYD1-MINY)<ZD1*DY) AND (ABS(SYG1-MAXY)<ZD1*DY)) OR (K>5);
         SYD:=SYD1; SYG:=SYG1;
         MAXYP:=MAX(SYG,MAXY);
         MINYP:=MIN(SYD,MINY);
         Y22:=ROUND(Y3+MINYP*(Y3-Y1)/(MAXYP-MINYP));
         PSY:=0
       END;
       IF (MAXY>0) AND (MINY>=0) THEN
       BEGIN
         Y33:=Y33-10; Y3:=Y33;
         Y22:=Y33;
         KDY:=0; KGY:=LDY;
         K:=0;
         REPEAT
           SYD:=Z(MINY,WYKY,K); SYG:=Z(SY*KGY+SYD,WYKY,K);
           INC(K)
         UNTIL ((SYD<>SYG) AND ((SYG-SYD)>ZD*DY) AND (ABS(SYD-MINY)<ZD1*DY/2) AND (ABS(SYD-MINY)<ZD1*DY)) OR (K>5);
         PSY:=SYD;
         MINYP:=MIN(SYD,MINY); MAXYP:=MAX(SYG,MAXY)
       END;
       IF (MAXY<=0) AND (MINY<0) THEN
       BEGIN
         Y22:=Y1; Y1:=Y22;
         KDY:=LDY; KGY:=0;
         K:=0;
         REPEAT
           SYG:=Z(MAXY,WYKY,K); SYD:=Z(-KDY*SY+SYG,WYKY,K);
           INC(K)
         UNTIL ((SYD<>SYG) AND ((SYG-SYD)>ZD*DY) AND (ABS(SYG-MAXY)<ZD1*DY/2) AND (ABS(SYD-MINY)<ZD1*DY)) OR (K>5);
         PSY:=SYG;
         MAXYP:=MAX(SYG,MAXY); MINYP:=MIN(SYD,MINY)
       END
     END; { SKALOWANIE_Y }


     PROCEDURE RYSUJ(X11,X22,X33,X3,Y11,Y22,Y33,Y3,
                     KDX,KGX,KDY,KGY,WYKX,WYKY         :INTEGER;
                     PSX,PSY,MINXP,MINYP,WSX,WSY,SX,SY :FLOAT;
                     NAZWAX,NAZWAY                     :STRING);
     VAR I,K,X,Y,AX :INTEGER;
         XP         :FLOAT;
         TWYK       :STRING;
     BEGIN
       SETLINESTYLE(DottedLn,0,1);
       LINE(X11,Y11,X11,Y33);      LINE(X33,Y22,X22,Y22);
       SETLINESTYLE(SolidLn,0,1);
       LINE(X11,Y11,X11-5,Y11+10); LINE(X11,Y11,X11+5,Y11+10);
       LINE(X22,Y22,X22-10,Y22-4); LINE(X22,Y22,X22-10,Y22+4);
       SETTEXTSTYLE(2,HORIZDIR,5);
       SETTEXTJUSTIFY(LEFTTEXT,CENTERTEXT);  OUTTEXTXY(X11+15,Y11,NAZWAY);
       SETTEXTJUSTIFY(RIGHTTEXT,CENTERTEXT); OUTTEXTXY(GETMAXX,Y22-10,NAZWAX);
       SETTEXTJUSTIFY(LEFTTEXT,CENTERTEXT);
       IF (WYKX>2) OR (WYKX<0) THEN
       BEGIN
         STR(WYKX,TWYK);
         SETTEXTSTYLE(0,HORIZDIR,1); OUTTEXTXY(GETMAXX-60,Y22+10,'x10');
         SETTEXTSTYLE(2,HORIZDIR,4); OUTTEXTXY(GETMAXX-35,Y22+5,TWYK)
       END;
       IF (WYKY>2) OR (WYKY<0) THEN
       BEGIN
         STR(WYKY,TWYK);
         SETTEXTSTYLE(0,HORIZDIR,1); OUTTEXTXY(X11-50,Y11+7,'x10');
         SETTEXTSTYLE(2,HORIZDIR,4); OUTTEXTXY(X11-25,Y11,TWYK)
       END;
       SETTEXTJUSTIFY(RightText,CenterText);
       SETTEXTSTYLE(2,HORIZDIR,4);
       FOR I:=0 TO KGY DO
       BEGIN
         XP:=I*SY+PSY;
         TWYK:=T(XP,WYKY);
         AX:=ROUND((XP-MINYP)*WSY);
         IF LENGTH(TWYK)*8>X11-10
           THEN OUTTEXTXY(LENGTH(TWYK)*8+10,Y3-AX,TWYK)
           ELSE OUTTEXTXY(X11-10,Y3-AX,TWYK);
         LINE(X11-6,Y3-AX,X11,Y3-AX)
       END;
       FOR I:=1 TO KDY DO
       BEGIN
         XP:=-I*SY+PSY;
         TWYK:=T(XP,WYKY);
         AX:=ROUND((XP-MINYP)*WSY);
         IF LENGTH(TWYK)*8>X11-10
           THEN OUTTEXTXY(LENGTH(TWYK)*8+10,Y3-AX,TWYK)
           ELSE OUTTEXTXY(X11-10,Y3-AX,TWYK);
         LINE(X11-6,Y3-AX,X11,Y3-AX)
       END;
       SETTEXTJUSTIFY(CenterText,TopText);
       FOR I:=0 TO KGX DO
       BEGIN
         XP:=I*SX+PSX;
         AX:=ROUND((XP-MINXP)*WSX);
         OUTTEXTXY(X3+AX,Y22+7,T(XP,WYKX)); LINE(X3+AX,Y22,X3+AX,Y22+5)
       END;
       FOR I:=1 TO KDX DO
       BEGIN
         XP:=-I*SX+PSX;
         AX:=ROUND((XP-MINXP)*WSX);
         OUTTEXTXY(X3+AX,Y22+7,T(XP,WYKX)); LINE(X3+AX,Y22,X3+AX,Y22+5)
       END
     END; { RYSUJ }


     PROCEDURE RYSUJ1(VAR WX,WY                 :WEKI;
                          N,
                          X22,X33,X3,Y11,Y33,Y3 :INTEGER;
                          MINXP,MINYP,WSX,WSY   :FLOAT);
     VAR I,K,X,Y:INTEGER;
     BEGIN
       I:=0;
       REPEAT
         X:=X3+ROUND((WX[I]-MINXP)*WSX); Y:=Y3-ROUND((WY[I]-MINYP)*WSY);
         INC(I)
       UNTIL (X>=X33) AND (X<=X22) AND (Y>=Y11) AND (Y<=Y33);
       MOVETO(X,Y);
       FOR K:=I TO N DO
       BEGIN
         X:=X3+ROUND((WX[K]-MINXP)*WSX);
         Y:=Y3-ROUND((WY[K]-MINYP)*WSY);
         IF (X>=X33) AND (X<=X22) AND (Y>=Y11) AND (Y<=Y33) THEN
           LINETO(X,Y)
       END
     END; { RYSUJ1 }


  PROCEDURE WYKRESXY;
  CONST ZD=0.9;   { Zaokraglenie podzalki }
        ZD1=1-ZD;
  VAR
    LDX,LDY,
    KGY,KDY,KDX,KGX,
    X1,X11,X2,X22,X3,X33,
    Y1,Y11,Y2,Y22,Y3,Y33,
    K                       :INTEGER;
    MAXY,MINY,MAXX,MINX,
    MAXXP,MINXP,MAXYP,MINYP,
    S,SMX,SMY,SX,SY,ST,
    SXD,SXG,SYD,SYG,
    DX,DY                   :FLOAT;
    WYKX1,WYKY1,
    WYKX,WYKY :INTEGER;  { Wykladniki skali na osiach OX i OY              }
    PSX,PSY,             { Wspolrzedne poczatku ukladu wspolrzednych       }
    WSX,WSY   :FLOAT;    { Wspolczynniki skali                             }


  BEGIN
    IF TYTULRYS2=''
      THEN Y33:=GETMAXY-30
      ELSE Y33:=GETMAXY-50;
    Y1:=30; Y11:=5;
    Y3:=Y33-10;
    MAXY:=WY[0]; MINY:=WY[0]; MAXX:=WX[0]; MINX:=WX[0];
    FOR K:=1 TO N DO
    BEGIN
      IF MAXY<WY[K]
        THEN MAXY:=WY[K]
        ELSE IF MINY>WY[K] THEN
               MINY:=WY[K];
      IF MAXX<WX[K]
        THEN MAXX:=WX[K]
        ELSE IF MINX>WX[K] THEN
               MINX:=WX[K]
    END;
    DX:=MAXX-MINX;
    DY:=MAXY-MINY;
    ZAOKRAGL(MAXX,DX); ZAOKRAGL(MINX,DX);
    ZAOKRAGL(MAXY,DX); ZAOKRAGL(MINY,DX);
    SKALA(DX,LDX,SMX,SX,WYKX1);
    SKALA(DY,LDY,SMY,SY,WYKY1);
    WYKX:=TRUNC(MAX(WYK(MINX),WYK(MAXX)));
    WYKY:=TRUNC(MAX(WYK(MINY),WYK(MAXY)));
    IF WYKX>(WYKX1+2) THEN
      WYKX:=WYKX1;
    IF WYKY>(WYKY1+2) THEN
      WYKY:=WYKY1;
    SKALOWANIE_X(MINX,MAXX,SXD,SXG,MINXP,MAXXP,PSX,DX,SX,ZD,ZD1,KDX,KGX,X1,X11,X2,X22,X3,X33,LDX,WYKX);
    SKALOWANIE_Y(MINY,MAXY,SYD,SYG,MINYP,MAXYP,PSY,DY,SY,ZD,ZD1,KDY,KGY,Y1,Y11,Y22,Y3,Y33,LDY,WYKY);
    SX:=(SXG-SXD)/(KGX+KDX); SY:=(SYG-SYD)/(KGY+KDY);
    WSX:=(X2-X3)/(MAXXP-MINXP); WSY:=(Y3-Y1)/(MAXYP-MINYP);
    RYSUJ(X11,X22,X33,X3,Y11,Y22,Y33,Y3,KDX,KGX,KDY,KGY,
          WYKX,WYKY,PSX,PSY,MINXP,MINYP,WSX,WSY,SX,SY,NAZWAX,NAZWAY);
    RYSUJ1(WX,WY,N,X22,X33,X3,Y11,Y33,Y3,MINXP,MINYP,WSX,WSY);
    SETTEXTJUSTIFY(LeftText,CenterText);
    SETTEXTSTYLE(0,HORIZDIR,1);
    OUTTEXTXY(20,Y33+25,TYTULRYS1);
    IF TYTULRYS2<>'' THEN
      OUTTEXTXY(20,Y33+35,TYTULRYS2)
  END { WYKRES };


  PROCEDURE WYKRESXYG;
  BEGIN
    INICJACJA_TRYBU_WYSOKIEJ_ROZDZIELCZOSCI;
    WYKRESXY(WX,WY,N,TYTULRYS1,TYTULRYS2,NAZWAX,NAZWAY);
    PAUSE;
    CLOSEGRAPH
  END; { WYKRESXY }


END .