PROGRAM PRZ7_4;
  {$IFDEF CPU87} {$N+}
         {$ELSE} {$N-}
  {$ENDIF}
USES CRT,TFLOAT,ALGEZES,FOURIER,WYKRESY,KOM_BLAD;
VAR  k,i,N,N1,N2       :WORD;
     p                 :BYTE;
     TX,T0,t,dt,w,w0,ww,e   :FLOAT;
     Ep,El             :WEKD2;
     W1,W2             :WEKI;
     WYB,CH            :CHAR;
     BLAD              :BYTE;
     UT1,UT2,UT3       :STRING;
     EXPW              :WEKZD2;

   PROCEDURE DANE;
     BEGIN        { Przykladowe dane liczbowe }
       T0:=0.02 {sek};{ Okres zadanej funkcji }
                {                        p    }
       p:=9;    { Wykladnik potegi  N = 2     }
       N:=POTEGA2(p);  w0:=100*PI/T0 ;  ww:=2*PI/T0;
       dt:=PI/w0;
     END;

   PROCEDURE TRAN_FOU1(VAR Y:ZESPOL; w:FLOAT); FAR;
     VAR Y1:ZESPOL;
     BEGIN
       Y1.RE:=1/T0;;  Y1.IM:=w;
       ODW(Y,Y1)
     END { TRAN_FOU1 };

   PROCEDURE TRAN_FOU2(VAR Y:ZESPOL; w:FLOAT); FAR;
     BEGIN
       IF ABS(w)<>ww
         THEN BEGIN
                Y.RE:=SIN((ww-w)*T0/4)/(ww-w)+SIN((ww+w)*T0/4)/(ww+w);
                Y.IM:=0
              END
         ELSE BEGIN
                Y.RE:=T0/4; Y.IM:=0
              END
     END { TRAN_FOU2 };

   FUNCTION U1(t:FLOAT):FLOAT;  FAR;
     BEGIN
       IF t>=0
         THEN U1:=EXP(-t/T0)
         ELSE U1:=0
     END { U1 };

   FUNCTION U2(t:FLOAT):FLOAT;  FAR;
     BEGIN
       IF ABS(t)<=T0/4
         THEN U2:=COS(ww*t)
         ELSE U2:=0
     END { U2 };

   PROCEDURE TYTUL(NAZWA_FUNKCJI:STRING);
     BEGIN
       CLRSCR;
       WRITELN('  Obliczenia testujace - odwrotnej transf. Fouriera');
       WRITELN(NAZWA_FUNKCJI);
       WRITELN('            Analitycznie      Przyblizenie     Blad bezwzgledny');
       WRITELN('   t            u(t)             up(t)              du(t)')
    END {TYTUL};

   PROCEDURE DRUKUJ(    U             :FUNX;
                    VAR Ep,El         :WEKD2;
                        N             :WORD;
                        NAZWA_FUNKCJI :STRING);
     VAR i          :INTEGER;
         e1,e2,de,t :FLOAT;
         CH         :CHAR;
     BEGIN
       TYTUL(NAZWA_FUNKCJI);
       FOR i:=-N+1 TO N-1 DO
       BEGIN
         t:=i*dt;
         IF t>=0
           THEN e1:=Ep^[i]
           ELSE e1:=El^[-i];
         e2:=U(t);  de:=e2-e1;
         WRITELN(t:9:6,e2:14:7,e1:17:7,de:19:7);
         IF FRAC((N+i)/20)=0 THEN
         BEGIN
           CH:=READKEY;
           TYTUL(NAZWA_FUNKCJI)
         END
       END;
       WRITE(#7);
       CH:=READKEY
     END { DRUKUJ };

    PROCEDURE TEKSTY;
      BEGIN
        UT1:='jezeli t>=0 to u(t):=EXP(-t/T0) przeciwnie u(t):=0 ';
        UT2:='jezeli ABS(t)<=T0/4 to u(t)=COS(2*PI*t/T0) '+
             'przeciwnie u(t)=0'
      END { TEKSTY };

  PROCEDURE WYKRES(UT:STRING);
    BEGIN
      FOR i:=0 TO N2 DO
      BEGIN
        W1[N2-i]:=-i*dt; W1[N2+i]:=i*dt;
        W2[N2+i]:=Ep^[i];
        IF i<N2 THEN
          W2[i]:=El^[N2-i]
      END;
      WYKRESXYG(W1,W2,N1,'Przyblizony przebieg funkcji '+
                'obliczony z dyskretnej odwrotnej transformacji Fouriera',
                'oryginal ma postac '+ UT,'t [sek]','u(t) [V]');
    END { WYKRES };

   PROCEDURE MENU;
     BEGIN
      CLRSCR;
      WRITELN(' Obliczenia testujace - transformacja odwrotna Fouriera');
      WRITELN;
      WRITELN(' L - porownanie oryginalu z transformacja odwrotna'+
              ' Fouriera wg FFT oryginal ');
      WRITELN('     ma postac ',UT2) ;
      WRITELN;
      WRITELN(' W - porownanie oryginalu z transformacja odwrotna'+
              ' Fouriera wg FFT oryginal ');
      WRITELN('     ma postac ',UT1) ;
      WRITELN;
      WRITELN(' K - koniec wyboru');
    END { MENU };

BEGIN  { Blok glowny programu }
  CLRSCR;
  DANE; TEKSTY;
  NEW(Ep);  NEW(El);
  REPEAT
    MENU;
    WYB:=UPCASE(READKEY);
    CLRSCR;
    CASE WYB OF
     'L': BEGIN
            ODW_TRAN_FOU(TRAN_FOU2,w0,TX,dt,Ep,El,p,N,BLAD);
            IF BLAD=0 THEN
            BEGIN
              N1:=N SHR 2;   N2:=N SHR 3;
              DRUKUJ(U2,Ep,El,N2,UT2);
              WYKRES(UT2)
            END
          END {L};
     'W': BEGIN
            ODW_TRAN_FOU(TRAN_FOU1,w0,TX,dt,Ep,El,p,N,BLAD);
            IF BLAD=0 THEN
            BEGIN
              N1:=N SHR 2;   N2:=N SHR 3;
              DRUKUJ(U1,Ep,El,N2,UT1);
              WYKRES(UT1)
            END
          END {W}
    END;
    IF BLAD<>0 THEN
    BEGIN
      PISZ_KOM_BLAD(BLAD);
      CH:=READKEY
    END
  UNTIL WYB='K';
  DISPOSE(Ep); DISPOSE(El)
END.
