PROGRAM PRZ7_2;
  {$IFDEF CPU87} {$N+}
         {$ELSE} {$N-}
  {$ENDIF}
   USES CRT,TFLOAT,ALGEZES,FOURIER,WYKRESY,KOM_BLAD;
   VAR  k,i,N,N1          :WORD;
        p                 :BYTE;
        T0,t,dt,Um,w,alfa :FLOAT;
        G                 :WEKZD2;
        W1,W2             :WEKI;
        WYB,CH            :CHAR;
        BLAD              :BYTE;
        UT1               :STRING;

   PROCEDURE DANE;
     BEGIN       { Przykladowe dane liczbowe   }
       T0:=0.02 {sek};{ Okres zadanej funkcji  }
       w:=2*PI/T0;
       alfa:=PI/8;
       Um:=100;  { Amplituda zadanej funkcji   }
                 {                        p    }
       p:=6;     { Wykladnik potegi  N = 2     }
     END;

   FUNCTION  U(t:FLOAT):FLOAT; { Funkcja okresowa (7.107) }
     BEGIN
       U:=Um*ABS(SIN(w*t+alfa))
     END { U };

   PROCEDURE WSPFOU;
   { Generacja zespolonych wspolczynnikow szeregu Fouriera }
   { wedlug wzorow (7.108)                                 }
     VAR S,S1,al:FLOAT;
     BEGIN
       S:=Um*4/PI;
       FOR i:=1 TO N DO
       BEGIN
         IF FRAC(i/2)=0
           THEN BEGIN
                  S1:=S/((i+1)*(i-1)); al:=i*alfa;
                  G^[i].RE:=-S1*COS(al);
                  G^[i].IM:=-S1*SIN(al)
                END
           ELSE BEGIN
                  G^[i].RE:=0; G^[i].IM:=0
                END
       END;
       G^[0].RE:=S;  G^[0].IM:=0;
     END { WSPFOU };

   PROCEDURE TYTUL(NAZWA_FUNKCJI:STRING);
      BEGIN
       CLRSCR;
       WRITELN('  Obliczenia testujace - suma szeregu Fouriera');
       WRITELN(NAZWA_FUNKCJI);WRITELN;
       WRITELN('               Analitycznie    Przyblizenie     Blad bezwzgledny');
       WRITELN('    t              u(t)           up(t)              du(t)')
    END { TYTUL };

   PROCEDURE DRUKUJ(VAR G             :WEKZD2;
                        N1            :WORD;
                        NAZWA_FUNKCJI :STRING);
     VAR i,k        :WORD;
         u1,u2,du   :FLOAT;
         CH         :CHAR;
     BEGIN
       TYTUL(NAZWA_FUNKCJI);
       dt:=T0/N1;
       FOR i:=0 TO N1-1 DO
       BEGIN
         t:=i*dt;
         u1:=G^[i].RE/2;  u2:=U(t);  du:=u2-u1;
         WRITELN(t:10:7,u2:16:7,u1:16:7,du:18:7);
         IF FRAC((i+1)/18)=0 THEN
         BEGIN
           CH:=READKEY;
           TYTUL(NAZWA_FUNKCJI)
         END;
       END;
       WRITE(#7);
       CH:=READKEY
     END { DRUKUJ };

    PROCEDURE TEKSTY;
      BEGIN
        UT1:=' u(t)=Um*ABS(SIN(w*t+alfa))  ';
      END { TEKSTY };

   PROCEDURE MENU;
     BEGIN
       CLRSCR;
       WRITELN(' Obliczenia testujace - suma szeregu Fouriera');
       WRITELN;
       WRITELN('    L -  porownanie oryginalu z suma szeregu wg FFT');
       WRITELN('         oryginal ma postac', UT1) ;
       WRITELN('    W -  wykres funkcji jako sumy szeregu Fouriera');
       WRITELN ;
       WRITELN('    K - koniec wyboru');
     END { MENU };

BEGIN  { Blok glowny programu }
  DANE; TEKSTY;
  NEW(G);
  N:=POTEGA2(p);
  WSPFOU;
  N1:=N SHL 1;
  FOR i:=1 TO N DO
    SPRZ(G^[N1-i],G^[i]);
  FFTCT(G,p+1,1,BLAD);
  dt:=T0/N1;
  IF BLAD=0
    THEN REPEAT
           MENU;
           WYB:=UPCASE(READKEY);
           CASE WYB OF
             'L': DRUKUJ(G,N1,UT1);
             'W': BEGIN
                    FOR i:=0 TO N1-1 DO
                    BEGIN
                      W1[i]:=i*dt;
                      W2[i]:=0.5*G^[i].RE;
                    END {i};
                    WYKRESXYG(W1,W2,N1-1,'Przyblizony przebieg funkcji '+
                              'obliczony z dyskretnej odwrotnej transformacji Fouriera',
                              ' oryginal funkcji ma postac  '+ UT1,'t [sek]','u(t) [V]');
                  END {W};
           END
         UNTIL WYB='K'
    ELSE PISZ_KOM_BLAD(BLAD);
  DISPOSE(G)
END.
