PROGRAM PRZ7_1;
  {$IFDEF CPU87} {$N+}
         {$ELSE} {$N-}
  {$ENDIF}
   USES CRT,TFLOAT,FOURIER,WYKRESY,KOM_BLAD;
   VAR  k,i,N           :WORD;
        p               :BYTE;
        T0,T2,t,dt,Um   :FLOAT;
        F,G             :WEKZD2;
        W1,W2           :WEKI;
        WYB,CH          :CHAR;
        UT1,UT2         :STRING;
        BLAD            :BYTE;

   PROCEDURE DANE;
     BEGIN      { Przykladowe dane liczbowe    }
       T0:=0.02 {sek}; { Okres zadanej funkcji }
       T2:=T0/2;
       Um:=100; { Amplituda zadanej funkcji    }
                {                        p     }
       p:=7;    { Wykladnik potegi  N = 2      }
     END;

   FUNCTION  U1(t:FLOAT):FLOAT; FAR;
   { Funkcja okresowa wg. wzoru (7.103) }
     BEGIN
       IF (t>=0) AND (t<T2)
         THEN U1:=Um
         ELSE IF (t>=T2) AND (t<=T0) THEN
                U1:=-Um
     END { U1 };

   PROCEDURE WSPFOU1;
   { Generacja zespolonych wspolczynnikow szeregu Fouriera }
   { wedlug wzorow (7.105)                                 }
     VAR S:FLOAT;
     BEGIN
       S:=Um*4/PI;
       FOR i:=0 TO N SHR 1 DO
       BEGIN
         IF FRAC(i/2)=0
           THEN BEGIN
                  G^[i].RE:=0; G^[i].IM:=0
                END
           ELSE BEGIN
                  G^[i].RE:=0; G^[i].IM:=-S/i
                END
         END
     END { WSPFOU1 };

   FUNCTION  U2(t:FLOAT):FLOAT;  FAR;
   { Funkcja okresowa wg. wzoru (7.104) }
     BEGIN
        U2:=Um*SQR(2*t/T0-1)
     END { U2 };

   PROCEDURE WSPFOU2;
   { Generacja zespolonych wspolczynnikow szeregu Fouriera }
   { wedlug wzorow (7.106)                                 }
     VAR S:FLOAT;
     BEGIN
       S:=4*Um/SQR(PI);
       G^[0].RE:=2*Um/3; G^[0].IM:=0;
       FOR i:=1 TO N SHR 1 DO
       BEGIN
         G^[i].RE:=S/SQR(i); G^[i].IM:=0
       END
     END { WSPFOU };

   PROCEDURE TYTUL(NAZWA_FUNKCJI:STRING);
      BEGIN
       CLRSCR;
       WRITELN('  Obliczenia testujace - wspolczynniki szeregu Fouriera');
       WRITELN(NAZWA_FUNKCJI);WRITELN;
       WRITE('Nr.   Analitycznie           Przyblizenie          Blad bezwzgledny ');
       WRITELN;
       WRITELN('n     a(n)       b(n)      ap(n)      bp(n)     a(n)-ap(n)   b(n)-bp(n) ')
    END {TYTUL};

   PROCEDURE DRUKUJ(VAR F,G           :WEKZD2;
                        N             :WORD;
                        NAZWA_FUNKCJI :STRING);
     VAR i,k               :WORD;
         a,b,a1,b1,da,db   :FLOAT;
         CH                :CHAR;
     BEGIN
       TYTUL(NAZWA_FUNKCJI);
       FOR i:=0 TO N SHR 1-1 DO
       BEGIN
         a:=G^[i].RE; b:=-G^[i].IM; a1:=F^[i].RE; b1:=-F^[i].IM;
         da:=G^[i].RE-F^[i].RE; db:=G^[i].IM-F^[i].IM;
         WRITELN(i:2,a:10:5,b:11:5,a1:10:5,b1:11:5,da:13:6,db:13:6);
         IF FRAC((i+1)/18)=0 THEN
         BEGIN
           CH:=READKEY;
           TYTUL(NAZWA_FUNKCJI)
         END;
       END;
       WRITE(#7);
       CH:=READKEY
     END { DRUKUJ };

    PROCEDURE TEKSTY;
      BEGIN
        UT1:=' u(t)=Um dla (t>=0)and(t<T0/2) oraz '+
             ' u(t)=Um dla (t>T0/2)and(t<=T0) ';
        UT2:=' u(t):=Um*SQR(2*t/T0-1) ';
      END { TEKSTY };

   PROCEDURE MENU;
     BEGIN
      CLRSCR;
      WRITELN(' Obliczenia testujace - wspolczynniki szeregu Fouriera');
      WRITELN;
      WRITELN('    L -  funkcja okresowa o okresie T0');
      WRITELN('         ',UT1) ;
      WRITELN('    F -  funkcja okresowa o okresie T0');
      WRITELN('         ',UT2) ;
      WRITELN('    K - koniec wyboru');
    END { MENU };

BEGIN  { Blok glowny programu }
  BLAD:=0;
  NEW(F); NEW(G);
  DANE; TEKSTY;
  REPEAT
    CLRSCR;
    MENU;
    WYB:=UPCASE(READKEY);
    CLRSCR;
    CASE WYB OF
      'L': BEGIN
             N:=POTEGA2(p);
             WSPFOU1;
             OWSFMST(U1,0,T0,F,p,BLAD);
             IF BLAD=0 THEN
             BEGIN
               DRUKUJ(F,G,N,UT1);
               FFTST(F,p,1,BLAD);
               IF BLAD=0 THEN
               BEGIN
                 dt:=T0/N;
                 FOR i:=0 TO N-1 DO
                 BEGIN
                   W1[i]:=i*dt;
                   W2[i]:=0.5*F^[i].RE
                 END;
                 WYKRESXYG(W1,W2,N-1,'Przyblizony przebieg funkcji '+
                           'obliczony z dyskretnej odwrotnej transformacji.Fouriera',
                           UT1,'t [sek]','u(t) [V]')
               END
             END
           END {L};
      'F': BEGIN
             N:=POTEGA2(p);
             WSPFOU2;
             OWSFMST(U2,0,T0,F,p,BLAD);
             IF BLAD=0 THEN
             BEGIN
               DRUKUJ(F,G,N,UT2);
               FFTST(F,p,1,BLAD);
               IF BLAD=0 THEN
               BEGIN
                 dt:=T0/N;
                 FOR i:=0 TO N-1 DO
                 BEGIN
                   W1[i]:=i*dt;
                   W2[i]:=0.5*F^[i].RE
                 END;
                 WYKRESXYG(W1,W2,N-1,'Przyblizony przebieg funkcji '+
                           'z dyskretnej odwrotnej transformacji Fouriera',
                            UT2,'t [sek]','u(t) [V]')
               END
             END
           END {F}
    END;
    IF BLAD<>0 THEN
    BEGIN
      PISZ_KOM_BLAD(BLAD);
      CH:=READKEY
    END
  UNTIL WYB='K';
  DISPOSE(F); DISPOSE(G)
END.
